/*
 * Decompiled with CFR 0.152.
 */
package ccl.xml;

import ccl.util.FileUtil;
import ccl.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XMLUtil {
    private static int _lastPrintable = 126;

    private static String getEntityRef(char ch) {
        switch (ch) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '\"': {
                return "quot";
            }
            case '\'': {
                return "apos";
            }
            case '&': {
                return "amp";
            }
        }
        return null;
    }

    private XMLUtil() {
    }

    public static String escape(char ch) {
        String charRef = XMLUtil.getEntityRef(ch);
        if (charRef != null) {
            return "&" + charRef + ";";
        }
        if (ch >= ' ' && ch <= _lastPrintable && ch != '\u00f7' || ch == '\n' || ch == '\r' || ch == '\t') {
            return "" + ch;
        }
        return "&#" + Integer.toString(ch) + ";";
    }

    public static String escape(String source) {
        if (source == null) {
            return "";
        }
        StringBuffer pBuffer = new StringBuffer();
        int i = 0;
        while (i < source.length()) {
            pBuffer.append(XMLUtil.escape(source.charAt(i)));
            ++i;
        }
        return pBuffer.toString();
    }

    public static String getXML(File xmlFile, String xsltFile) throws IOException, TransformerException {
        try {
            return XMLUtil.getXML(FileUtil.readFile(xmlFile.getPath()), xsltFile);
        }
        catch (TransformerException transformerException) {
            throw new TransformerException("XML file '" + xmlFile + "': " + Util.getStackTrace(transformerException));
        }
    }

    public static String getXML(File xmlFile, File xsltFile) throws IOException, TransformerException {
        try {
            return XMLUtil.getXML(FileUtil.readFile(xmlFile.getPath()), FileUtil.readFile(xsltFile.getPath()));
        }
        catch (TransformerException transformerException) {
            throw new TransformerException("XML file '" + xmlFile + "' or XSLT file '" + xsltFile + "': " + Util.getStackTrace(transformerException));
        }
    }

    public static String getXML(String xmlContent, File xsltFile) throws IOException, TransformerException {
        try {
            return XMLUtil.getXML(xmlContent, FileUtil.readFile(xsltFile.getPath()));
        }
        catch (TransformerException transformerException) {
            throw new TransformerException("XSLT file '" + xsltFile + "': " + Util.getStackTrace(transformerException));
        }
    }

    public static String getXML(String xmlContent, String xsltContent) throws TransformerException {
        StreamSource xmlSource = new StreamSource(new StringReader(xmlContent));
        StreamSource styleSource = new StreamSource(new StringReader(xsltContent));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(styleSource);
        ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
        StreamResult result = new StreamResult(output);
        transformer.transform(xmlSource, result);
        String retVal = output.toString();
        return retVal;
    }

    public static String getValueOf(String xmlContent, String xpath) throws Exception {
        String stylesheet = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\n<xsl:stylesheet\n   version=\"1.0\"\n   xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\n<xsl:output method=\"text\"/>\n\n<xsl:template match=\"/\"><xsl:value-of select=\"" + xpath + "\"/></xsl:template>\n" + "\n" + "</xsl:stylesheet>\n";
        return XMLUtil.getXML(xmlContent, stylesheet);
    }

    public static String getValueOf(File xmlFile, String xpath) throws Exception {
        String stylesheet = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\n<xsl:stylesheet\n   version=\"1.0\"\n   xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\n<xsl:output method=\"text\"/>\n\n<xsl:template match=\"/\"><xsl:value-of select=\"" + xpath + "\"/></xsl:template>\n" + "\n" + "</xsl:stylesheet>\n";
        return XMLUtil.getXML(xmlFile, stylesheet);
    }
}

