/*
 * Decompiled with CFR 0.152.
 */
package http.utils.multipartrequest;

import http.utils.multipartrequest.TempFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MultipartRequest {
    private static String charEncoding = "ISO-8859-1";
    private PrintWriter debug = null;
    private Hashtable htParameters = null;
    private Hashtable htFiles = null;
    private String strBoundary = null;
    private File fileOutPutDirectory = null;
    private boolean loadIntoMemory = false;
    private long intContentLength;
    private long intTotalRead;
    public static final int MAX_READ_BYTES = 0x200000;
    public static final int READ_LINE_BLOCK = 131072;
    private byte[] blockOfBytes = null;
    public static final int FILENAME = 0;
    public static final int CONTENT_TYPE = 1;
    public static final int SIZE = 2;
    public static final int CONTENTS = 3;
    public static final int TMP_FILENAME = 4;

    public static synchronized void setEncoding(String enc) throws UnsupportedEncodingException {
        if (enc == null || enc.trim() == "") {
            charEncoding = System.getProperty("file.encoding");
        } else {
            new String(new byte[]{10}, enc);
            charEncoding = enc;
        }
    }

    public static String getEncoding() {
        return charEncoding;
    }

    public MultipartRequest(String strContentTypeText, int intContentLength, InputStream in, String strSaveDirectory) throws IllegalArgumentException, IOException {
        this(null, strContentTypeText, intContentLength, in, strSaveDirectory, 0x200000);
    }

    public MultipartRequest(String strContentTypeText, int intContentLength, InputStream in, String strSaveDirectory, int intMaxReadBytes) throws IllegalArgumentException, IOException {
        this(null, strContentTypeText, intContentLength, in, strSaveDirectory, intMaxReadBytes);
    }

    public MultipartRequest(PrintWriter debug, String strContentTypeText, int intContentLength, InputStream in, String strSaveDirectory) throws IllegalArgumentException, IOException {
        this(debug, strContentTypeText, intContentLength, in, strSaveDirectory, 0x200000);
    }

    public MultipartRequest(PrintWriter debug, String strContentTypeText, int intContentLength, InputStream in, int intMaxReadBytes) throws IllegalArgumentException, IOException {
        this.loadIntoMemory = true;
        this.init(debug, strContentTypeText, intContentLength, in, intMaxReadBytes);
    }

    public MultipartRequest(PrintWriter debug, String strContentTypeText, int intContentLength, InputStream in, String strSaveDirectory, int intMaxReadBytes) throws IllegalArgumentException, IOException {
        if (strSaveDirectory != null) {
            this.fileOutPutDirectory = new File(strSaveDirectory);
            if (!this.fileOutPutDirectory.exists()) {
                throw new IOException("Directory [" + strSaveDirectory + "] is invalid.");
            }
            if (!this.fileOutPutDirectory.canWrite()) {
                throw new IOException("Directory [" + strSaveDirectory + "] is readonly.");
            }
        }
        this.init(debug, strContentTypeText, intContentLength, in, intMaxReadBytes);
    }

    private void init(PrintWriter debug, String strContentTypeText, int intContentLength, InputStream in, int intMaxReadBytes) throws IllegalArgumentException, IOException {
        this.debug = debug;
        if (strContentTypeText == null || !strContentTypeText.startsWith("multipart/form-data") || strContentTypeText.indexOf("boundary=") == -1) {
            this.debug("ContentType = " + strContentTypeText);
            throw new IllegalArgumentException("Invalid Content Type.");
        }
        this.strBoundary = strContentTypeText.substring(strContentTypeText.indexOf("boundary=") + "boundary=".length()).trim();
        this.intContentLength = intContentLength;
        if (intContentLength > intMaxReadBytes) {
            this.debug("ContentLength = " + intContentLength);
            this.debug("MaxReadBytes = " + intMaxReadBytes);
            throw new IOException("Content Length Error (" + intContentLength + " > " + intMaxReadBytes + ")");
        }
        this.htParameters = new Hashtable();
        this.htFiles = new Hashtable();
        this.blockOfBytes = new byte[131072];
        this.intTotalRead = 0L;
        this.parse(new BufferedInputStream(in));
        this.blockOfBytes = null;
        this.debug = null;
        this.strBoundary = null;
    }

    public String getURLParameter(String strName) {
        Object value = this.htParameters.get(strName);
        if (value instanceof Vector) {
            return (String)((Vector)value).firstElement();
        }
        return (String)this.htParameters.get(strName);
    }

    public Enumeration getURLParameters(String strName) {
        Object value = this.htParameters.get(strName);
        if (value instanceof Vector) {
            return ((Vector)value).elements();
        }
        Vector vector = new Vector();
        if (value != null) {
            vector.addElement(value);
        }
        return vector.elements();
    }

    public Enumeration getParameterNames() {
        return this.htParameters.keys();
    }

    public Enumeration getFileParameterNames() {
        return this.htFiles.keys();
    }

    public String getContentType(String strName) {
        return (String)this.getFileParameter(strName, 1);
    }

    public InputStream getFileContents(String strName) {
        Object obj = this.getFileParameter(strName, 3);
        if (obj != null) {
            return new ByteArrayInputStream((byte[])obj);
        }
        return null;
    }

    public File getFile(String strName) {
        if (this.getFileSize(strName) > 0L && this.fileOutPutDirectory != null) {
            return (File)this.getFileParameter(strName, 4);
        }
        return null;
    }

    public String getFileSystemName(String strName) {
        return (String)this.getFileParameter(strName, 0);
    }

    public long getFileSize(String strName) {
        Object obj = this.getFileParameter(strName, 2);
        if (obj != null) {
            return (Long)obj;
        }
        return -1L;
    }

    public Object getFileParameter(String strName, int type) {
        Object[] objArray = null;
        Object value = this.htFiles.get(strName);
        objArray = value instanceof Vector ? (Object[])((Vector)value).firstElement() : (Object[])this.htFiles.get(strName);
        if (objArray != null && type >= 0 && type <= 4) {
            return objArray[type];
        }
        return null;
    }

    private void parse(InputStream in) throws IOException {
        String strContentType = null;
        String strName = null;
        String strFilename = null;
        String strLine = null;
        int read = -1;
        read = this.readLine(in, this.blockOfBytes);
        String string = strLine = read > 0 ? new String(this.blockOfBytes, 0, read, charEncoding) : null;
        if (strLine == null || strLine.indexOf(this.strBoundary) == -1) {
            throw new IOException("Invalid Form Data, no boundary encountered.");
        }
        while ((read = this.readLine(in, this.blockOfBytes)) > 0 && (strLine = new String(this.blockOfBytes, 0, read, charEncoding)) != null && strLine.length() != 0 && strLine.trim().length() != 0) {
            strName = MultipartRequest.trimQuotes(MultipartRequest.getValue("name", strLine));
            strFilename = MultipartRequest.trimQuotes(MultipartRequest.getValue("filename", strLine));
            if (strFilename == null) {
                this.readLine(in, this.blockOfBytes);
                String param = this.readParameter(in);
                this.addParameter(strName, param);
                continue;
            }
            if (strFilename.length() == 0) {
                read = this.readLine(in, this.blockOfBytes);
                String string2 = strLine = read > 0 ? new String(this.blockOfBytes, 0, read, charEncoding) : null;
                if (strLine != null && strLine.toLowerCase().startsWith("content-type:")) {
                    this.readLine(in, this.blockOfBytes);
                }
                this.readLine(in, this.blockOfBytes);
                this.addFileParameter(strName, new Object[]{null, null, null, null, null});
                this.readLine(in, this.blockOfBytes);
                continue;
            }
            read = this.readLine(in, this.blockOfBytes);
            strLine = read > 0 ? new String(this.blockOfBytes, 0, read, charEncoding) : null;
            strContentType = "application/octet-stream";
            if (strLine != null && strLine.toLowerCase().startsWith("content-type:")) {
                strContentType = strLine.substring("content-type:".length()).trim();
                this.readLine(in, this.blockOfBytes);
            }
            long filesize = -1L;
            byte[] contentsOfFile = null;
            File outFile = null;
            strFilename = MultipartRequest.getBasename(strFilename);
            if (this.loadIntoMemory) {
                contentsOfFile = this.readFile(in);
                if (contentsOfFile != null) {
                    filesize = contentsOfFile.length;
                }
            } else {
                if (this.fileOutPutDirectory != null) {
                    int indexOfDot = strFilename.lastIndexOf(".");
                    String prefix = strFilename;
                    String suffix = null;
                    if (indexOfDot != -1) {
                        prefix = strFilename.substring(0, indexOfDot);
                        suffix = strFilename.substring(indexOfDot + 1);
                    } else {
                        prefix = strFilename;
                        suffix = "tmp";
                    }
                    outFile = TempFile.createTempFile(prefix, suffix, this.fileOutPutDirectory);
                }
                filesize = this.readAndWriteFile(in, outFile);
            }
            if (filesize > 0L) {
                this.addFileParameter(strName, new Object[]{strFilename, strContentType, new Long(filesize), contentsOfFile, outFile});
                continue;
            }
            this.addFileParameter(strName, new Object[]{strFilename, null, new Long(0L), null, null});
        }
    }

    private void addParameter(String strName, String value) {
        Object objParms = this.htParameters.get(strName);
        if (objParms instanceof Vector) {
            ((Vector)objParms).addElement(value);
        } else if (objParms instanceof String) {
            Vector<Object> vecParms = new Vector<Object>();
            vecParms.addElement(objParms);
            vecParms.addElement(value);
            this.htParameters.put(strName, vecParms);
        } else {
            this.htParameters.put(strName, value);
        }
    }

    private void addFileParameter(String strName, Object[] fileObj) {
        Object objParms = this.htFiles.get(strName);
        if (objParms instanceof Vector) {
            ((Vector)objParms).addElement(fileObj);
        } else if (objParms instanceof Object[]) {
            Vector<Object> vecParms = new Vector<Object>();
            vecParms.addElement(objParms);
            vecParms.addElement(fileObj);
            this.htFiles.put(strName, vecParms);
        } else {
            this.htFiles.put(strName, fileObj);
        }
    }

    private String readParameter(InputStream in) throws IOException {
        StringBuffer buf = new StringBuffer();
        int read = -1;
        String line = null;
        while (true) {
            if ((read = this.readLine(in, this.blockOfBytes)) < 0) {
                throw new IOException("Stream ended prematurely.");
            }
            line = new String(this.blockOfBytes, 0, read, charEncoding);
            if (read < this.blockOfBytes.length && line.indexOf(this.strBoundary) != -1) break;
            buf.append(line);
        }
        if (buf.length() > 0) {
            buf.setLength(MultipartRequest.getLengthMinusEnding(buf));
        }
        return buf.toString();
    }

    private long readAndWrite(InputStream in, OutputStream out) throws IOException {
        long fileSize = 0L;
        int read = -1;
        byte[] secondLineOfBytes = new byte[this.blockOfBytes.length];
        int sizeOfSecondArray = 0;
        while (true) {
            if ((read = this.readLine(in, this.blockOfBytes)) < 0) {
                throw new IOException("Stream ended prematurely.");
            }
            if (read < this.blockOfBytes.length && new String(this.blockOfBytes, 0, read, charEncoding).indexOf(this.strBoundary) != -1) {
                int actualLength;
                if (sizeOfSecondArray == 0 || (actualLength = MultipartRequest.getLengthMinusEnding(secondLineOfBytes, sizeOfSecondArray)) <= 0 || out == null) break;
                out.write(secondLineOfBytes, 0, actualLength);
                fileSize += (long)actualLength;
                break;
            }
            if (sizeOfSecondArray != 0) {
                out.write(secondLineOfBytes, 0, sizeOfSecondArray);
                fileSize += (long)sizeOfSecondArray;
            }
            if (out == null) continue;
            System.arraycopy(this.blockOfBytes, 0, secondLineOfBytes, 0, read);
            sizeOfSecondArray = read;
        }
        return fileSize;
    }

    private long readAndWriteFile(InputStream in, File outFile) throws IOException {
        long count;
        BufferedOutputStream out = null;
        if (outFile != null && outFile.exists() && outFile.canWrite()) {
            out = new BufferedOutputStream(new FileOutputStream(outFile));
        }
        if ((count = this.readAndWrite(in, out)) > 0L) {
            out.flush();
            out.close();
        } else {
            if (out != null) {
                out.close();
            }
            outFile.delete();
        }
        return count;
    }

    private byte[] readFile(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        long count = this.readAndWrite(in, out);
        if (count > 0L) {
            return out.toByteArray();
        }
        return null;
    }

    private static final int getLengthMinusEnding(byte[] byteLine, int endOfArray) {
        if (byteLine == null) {
            return 0;
        }
        if (endOfArray >= 2 && byteLine[endOfArray - 2] == 13 && byteLine[endOfArray - 1] == 10) {
            return endOfArray - 2;
        }
        if (endOfArray >= 1 && byteLine[endOfArray - 1] == 10 || byteLine[endOfArray - 1] == 13) {
            return endOfArray - 1;
        }
        return endOfArray;
    }

    private static final int getLengthMinusEnding(StringBuffer buf) {
        if (buf.length() >= 2 && buf.charAt(buf.length() - 2) == '\r' && buf.charAt(buf.length() - 1) == '\n') {
            return buf.length() - 2;
        }
        if (buf.length() >= 1 && buf.charAt(buf.length() - 1) == '\n' || buf.charAt(buf.length() - 1) == '\r') {
            return buf.length() - 1;
        }
        return buf.length();
    }

    private int readLine(InputStream in, byte[] bytesToBeRead) throws IOException {
        int result;
        if (this.intTotalRead >= this.intContentLength) {
            return -1;
        }
        int length = bytesToBeRead.length;
        if ((long)length > this.intContentLength - this.intTotalRead) {
            length = (int)(this.intContentLength - this.intTotalRead);
        }
        if ((result = this.readLine(in, bytesToBeRead, 0, length)) > 0) {
            this.intTotalRead += (long)result;
        }
        return result;
    }

    private static final String getBasename(String strFilename) {
        if (strFilename == null) {
            return strFilename;
        }
        int intIndex = strFilename.lastIndexOf("/");
        if (intIndex == -1 || strFilename.lastIndexOf("\\") > intIndex) {
            intIndex = strFilename.lastIndexOf("\\");
        }
        if (intIndex != -1) {
            return strFilename.substring(intIndex + 1);
        }
        return strFilename;
    }

    private static final String trimQuotes(String strItem) {
        if (strItem == null || strItem.indexOf("\"") == -1) {
            return strItem;
        }
        if ((strItem = strItem.trim()).charAt(0) == '\"') {
            strItem = strItem.substring(1);
        }
        if (strItem.charAt(strItem.length() - 1) == '\"') {
            strItem = strItem.substring(0, strItem.length() - 1);
        }
        return strItem;
    }

    private static final String getValue(String strName, String strToDecode) {
        strName = strName + "=";
        int startIndexOf = 0;
        while (startIndexOf < strToDecode.length()) {
            int indexOf = strToDecode.indexOf(strName, startIndexOf);
            if (indexOf != -1) {
                if (indexOf == 0 || Character.isWhitespace(strToDecode.charAt(indexOf - 1)) || strToDecode.charAt(indexOf - 1) == ';') {
                    int endIndexOf = strToDecode.indexOf(";", indexOf + strName.length());
                    if (endIndexOf == -1) {
                        return strToDecode.substring(indexOf + strName.length());
                    }
                    return strToDecode.substring(indexOf + strName.length(), endIndexOf);
                }
                startIndexOf = indexOf + strName.length();
                continue;
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private int readLine(InputStream in, byte[] b, int off, int len) throws IOException {
        int c;
        if (len <= 0) {
            return 0;
        }
        int count = 0;
        while ((c = in.read()) != -1) {
            void var6_6;
            b[off++] = (byte)var6_6;
            if (var6_6 == 10 || ++count == len) break;
        }
        return count > 0 ? count : -1;
    }

    protected void debug(String x) {
        if (this.debug != null) {
            this.debug.println(x);
            this.debug.flush();
        }
    }

    public String getHtmlTable() {
        StringBuffer sbReturn = new StringBuffer();
        sbReturn.append("<h2>Parameters</h2>");
        sbReturn.append("\n<table border=3><tr><td><b>Name</b></td><td><b>Value</b></td></tr>");
        Enumeration e = this.getParameterNames();
        while (e.hasMoreElements()) {
            String strName = (String)e.nextElement();
            sbReturn.append("\n<tr><td>" + strName + "</td>");
            sbReturn.append("<td><table border=1><tr>");
            Enumeration f = this.getURLParameters(strName);
            while (f.hasMoreElements()) {
                String value = (String)f.nextElement();
                sbReturn.append("<td>" + value + "</td>");
            }
            sbReturn.append("</tr></table></td></tr>");
        }
        sbReturn.append("</table>");
        sbReturn.append("<h2>File Parameters</h2>");
        sbReturn.append("\n<table border=2><tr><td><b>Name</b></td><td><b>Filename</b></td><td><b>Path</b></td><td><b>Content Type</b></td><td><b>Size</b></td></tr>");
        Enumeration e2 = this.getFileParameterNames();
        while (e2.hasMoreElements()) {
            String strName = (String)e2.nextElement();
            sbReturn.append("\n<tr><td>" + strName + "</td>" + "<td>" + (this.getFileSystemName(strName) != null ? this.getFileSystemName(strName) : "") + "</td>");
            if (this.loadIntoMemory) {
                sbReturn.append("<td>" + (this.getFileSize(strName) > 0L ? "<i>in memory</i>" : "") + "</td>");
            } else {
                sbReturn.append("<td>" + (this.getFile(strName) != null ? this.getFile(strName).getAbsolutePath() : "") + "</td>");
            }
            sbReturn.append("<td>" + (this.getContentType(strName) != null ? this.getContentType(strName) : "") + "</td>" + "<td>" + (this.getFileSize(strName) != -1L ? this.getFileSize(strName) + "" : "") + "</td>" + "</tr>");
        }
        sbReturn.append("</table>");
        return sbReturn.toString();
    }
}

