% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feasible.R
\name{detect_infeasible_rules}
\alias{detect_infeasible_rules}
\title{Detect which rules cause infeasibility}
\usage{
detect_infeasible_rules(x, weight = numeric(), ...)
}
\arguments{
\item{x}{\code{\link{validator}} object with rules}

\item{weight}{optional named \code{\link{numeric}} with weights. Unnamed variables in the weight are given the default
weight \code{1}.}

\item{...}{not used}
}
\value{
\code{character} with the names of the rules that are causing infeasibility.
}
\description{
Detect which rules cause infeasibility. This methods tries to remove the minimum number of rules to make the system
mathematically feasible. Note that this may not result in your desired system, because some rules may be more important
to you than others. This can be mitigated by supplying weights for the rules. Default weight is 1.
}
\examples{
rules <- validator( x > 0)

is_infeasible(rules)

rules <- validator( rule1 = x > 0
                  , rule2 = x < 0
                  )

is_infeasible(rules)

detect_infeasible_rules(rules)
make_feasible(rules)

# find out the conflict with this rule
is_contradicted_by(rules, "rule1")
}
\seealso{
Other feasibility: \code{\link{detect_boundary_cat}},
  \code{\link{detect_boundary_num}},
  \code{\link{is_contradicted_by}},
  \code{\link{is_infeasible}}, \code{\link{make_feasible}}
}
\concept{feasibility}
