% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdfplot.R
\name{pdfplot}
\alias{pdfplot}
\title{Probability density function plot of the three-parameter Weibull distribution}
\usage{
pdfplot(x, shape, scale, location)
}
\arguments{
\item{x}{vector of quantiles}

\item{shape}{shape parameter (\eqn{\beta}) of the three-parameter Weibull distribution, where \eqn{\beta >0}.}

\item{scale}{scale parameter (\eqn{\alpha}) of the three-parameter Weibull distribution, where \eqn{\alpha > 0}.}

\item{location}{location parameter (\eqn{\delta}) of the three-parameter Weibull distribution, where \eqn{\delta \ge 0}.}
}
\value{
Probability density function plot of the three-parameter Weibull distribution.
}
\description{
Probability density function plot of the three-parameter Weibull distribution with specified \code{shape}, \code{scale} and \code{location}.
}
\examples{
x <- rtpwb(100,1.5,2,1)
pdfplot(x,1.5,2,1)

}
\references{
Johnson, N. L., Kotz, S. and Balakrishnan, N. (1995) Continuous Univariate Distributions, volume 1, chapter 21. Wiley, New York.
}
