% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability_output.R
\name{SelectionProportions}
\alias{SelectionProportions}
\alias{ConsensusMatrix}
\title{Selection/co-membership proportions}
\usage{
SelectionProportions(stability, argmax_id = NULL)

ConsensusMatrix(stability, argmax_id = NULL)
}
\arguments{
\item{stability}{output of \code{\link{VariableSelection}},
\code{\link{GraphicalModel}}, \code{\link{BiSelection}}, or
\code{\link{Clustering}}.}

\item{argmax_id}{optional indices of hyper-parameters. If
\code{argmax_id=NULL}, the calibrated hyper-parameters are used.}
}
\value{
A vector or matrix of proportions.
}
\description{
Extracts selection proportions (for stability selection) or co-membership
proportions (for consensus clustering).
}
\examples{
\donttest{
# Stability selection
set.seed(1)
simul <- SimulateRegression(pk = 50)
stab <- VariableSelection(xdata = simul$xdata, ydata = simul$ydata)
SelectionProportions(stab)

# Consensus clustering
set.seed(1)
simul <- SimulateClustering(
  n = c(30, 30, 30), nu_xc = 1, ev_xc = 0.5
)
stab <- Clustering(xdata = simul$data)
ConsensusMatrix(stab)
}

}
\seealso{
\code{\link{VariableSelection}}, \code{\link{GraphicalModel}},
  \code{\link{BiSelection}}, \code{\link{Clustering}}
}
