% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pb.R
\name{Poisson-beta}
\alias{Poisson-beta}
\alias{dpb}
\alias{ppb}
\alias{qpb}
\alias{rpb}
\title{Poisson-beta Distribution}
\usage{
dpb(x, alpha, beta, c = 1, log = FALSE)

ppb(q, alpha, beta, c = 1, lower.tail = TRUE, log.p = FALSE)

qpb(p, alpha, beta, c = 1, lower.tail = TRUE, log.p = FALSE)

rpb(n, alpha, beta, c = 1)
}
\arguments{
\item{x, q}{Vector of (non-negative integer) quantiles}

\item{alpha, beta}{Non-negative parameters of the beta distribution (shape1 and shape2)}

\item{c}{Numeric scaling parameter of the beta distribution. The standard beta is
scaled on (0,1) (default) and can be transformed to (0,c).}

\item{log, log.p}{Logical; if TRUE, probabilities p are given as log(p)}

\item{lower.tail}{Logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{p}{Vector of probabilities}

\item{n}{Number of observations}
}
\description{
Density, distribution function, quantile function and random generation for the
Poisson-beta distribution: a Poisson distribution whose parameter itself follows
a beta distribution. Alpha and beta are the parameters of this specific beta
distribution which is scaled on (0, c) in contrast to the usual scaling of the
standard beta distribution on (0,1).
}
\examples{
 X <- dpb(x=0:200, alpha=5, beta=3, c=20)
 plot(0:200, X, type='l')
 Y <- dpb(0:10, seq(10.0,11.0,by=0.1), seq(30.0,31.0,by=0.1), seq(10.2,11.2,by=0.1))
 Y <- ppb(q= 0 :200, alpha=5, beta= 3, c=20)
 plot(0:200, Y, type="l")
 Z <- qpb(p= seq(0,1, by= 0.01), alpha=5, beta= 3, c=20)
 plot(seq(0,1, by= 0.01),Z, type="l")
 RV <- rpb(n = 1000, alpha=5, beta= 3, c=20)
 plot(0 : 200, X, type="l")
 lines(density(RV), col="red")
 R2 <- rpb(11, seq(10.0,11.0,by=0.1), seq(30.0,31.0,by=0.1), seq(10.2,11.2,by=0.1))
}
\keyword{Poisson-beta}
\keyword{distribution}
