% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StEM_pcirt.R
\name{StEM_pcirt}
\alias{StEM_pcirt}
\title{Stochastic EM algorithm for solving generalized partial credit model}
\usage{
StEM_pcirt(response, Q, A0, D0, theta0, sigma0, m = 200, TT = 20,
  max_attempt = 40, tol = 1.5, precision = 0.015, parallel = F)
}
\arguments{
\item{response}{N by J matrix containing {0,1,...,M-1} responses, where N is the number of respondents and J is the number of items.}

\item{Q}{J by K matrix containing 0/1 entries, where J is the number of items and K is the number of latent traits. Each entry indicates whether an item measures a certain latent trait.}

\item{A0}{J by K matrix, the initial value of loading matrix.}

\item{D0}{J by M matrix containing the initial value of intercept parameters, where M is the number of response categories.}

\item{theta0}{N by K matrix, the initial value of latent traits for each respondent}

\item{sigma0}{K by K matrix, the initial value of correlations among latent traits.}

\item{m}{The length of Markov chain window for choosing burn-in size with a default value 200.}

\item{TT}{The batch size with a default value 20.}

\item{max_attempt}{The maximum attampt times if the precision criterion is not meet.}

\item{tol}{The tolerance of geweke statistic used for determining burn in size, default value is 1.5.}

\item{precision}{The pre-set precision value for determining the length of Markov chain, default value is 0.015.}

\item{parallel}{Whether or not enable the parallel computing with a default value FALSE.}
}
\value{
The function returns a list with the following components:
\describe{
  \item{A_hat}{The estimated loading matrix}
  \item{D_hat}{The estimated value of intercept parameters.}
  \item{sigma_hat}{The estimated value of correlation matrix of latent traits.}
  \item{burn_in_T}{The length of burn in size.}
}
}
\description{
Stochastic EM algorithm for solving generalized partial credit model
}
\examples{
# run a toy example based on the partial credit model

# load a simulated dataset
attach(data_sim_pcirt)

# generate starting values for the algorithm
A0 <- Q
D0 <- matrix(1, J, M)
D0[,1] <- 0
theta0 <- matrix(rnorm(N*K), N, K)
sigma0 <- diag(1, K)

# do the confirmatory partial credit model analysis 
# to enable multicore processing, set parallel = T
pcirt_res <- StEM_pcirt(response, Q, A0, D0, theta0, sigma0)

}
\references{
Zhang, S., Chen, Y. and Liu, Y. (2018). An Improved Stochastic EM Algorithm for Large-Scale Full-information Item Factor Analysis. \emph{British Journal of Mathematical and Statistical Psychology}. To appear.
D.C. Liu and J. Nocedal. On the Limited Memory Method for Large Scale Optimization (1989), Mathematical Programming B, 45, 3, pp. 503-528.
}
