## ----vignettesetup, include = FALSE-------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
library(haven)
set.seed(12345)

## -----------------------------------------------------------------------------
library(declared)

x2 <- declared(
  x = c(1:5, -91),
  labels = c("Missing" = -91),
  na_value = -91
)

## -----------------------------------------------------------------------------
x2 == -91
x2 == "Missing"

## -----------------------------------------------------------------------------
x2 <- c(x2, -91)
x2

## -----------------------------------------------------------------------------
labels(x2) <- c("Does not know" = -92, "Not responded" = -91)
x2

## -----------------------------------------------------------------------------
missing_values(x2) <- c(-91, -92)
missing_range(x2) <- c(-91, -95)
x2

## ----undeclare----------------------------------------------------------------
undeclare(x2, drop = TRUE)

## ----haven--------------------------------------------------------------------
xh <- as.haven(x2)
xh

as.declared(xh)

## ----dataframe----------------------------------------------------------------
dfm <- data.frame(x1 = letters[1:7], x2)
dfm

## ----tibble-------------------------------------------------------------------
tibble::as_tibble(dfm)

## ----sort---------------------------------------------------------------------
x3 <- declared(
  x = c(1:5, -91, NA, -92, -91),
  na_value = c(-92, -91)
)
sort(x3, na.last = TRUE)

## -----------------------------------------------------------------------------
sort(x3, na.last = TRUE, decreasing = TRUE)

## -----------------------------------------------------------------------------
sort(x3, na.last = TRUE, decreasing = TRUE, empty.last = FALSE)

## -----------------------------------------------------------------------------
x4 <- declared(
  x = c(1:3, -91),
  labels = c("Left" = 1, "Middle" = 2, "Right" = 3, "Apolitic" = -91),
  na_value = -91,
  label = "Respondent's political orientation"
)

x4

## -----------------------------------------------------------------------------
x5 <- factor(
  c("Left", "Middle", "Right", "Apolitic"),
  levels = c("Left", "Middle", "Right", "Apolitic")
)

x5

## -----------------------------------------------------------------------------
as.factor(x4)

# essentially acting as:
as.factor(drop_na(x4))

## -----------------------------------------------------------------------------
as.factor(undeclare(x4))

## -----------------------------------------------------------------------------
as.factor(x4, drop_na = FALSE)

## -----------------------------------------------------------------------------
as.declared(x5, na_values = 4)

## -----------------------------------------------------------------------------
as.character(x4)

## -----------------------------------------------------------------------------
as.character(undeclare(x4))

as.character(x4, drop_na = FALSE)

## -----------------------------------------------------------------------------
x6 <- declared(
  x = sample(
    c("a", "b", "c", "z"),
    20,
    replace = TRUE
  ),
  labels = c("Left" = "a", "Middle" = "b", "Right" = "c", "Apolitic" = "z"),
  na_values = "z"
)

x6

