% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knitr.R
\name{register_knitr_engine}
\alias{register_knitr_engine}
\title{Register CmdStanR's knitr engine for Stan}
\usage{
register_knitr_engine(override = TRUE)
}
\arguments{
\item{override}{(logical) Override knitr's built-in, RStan-based engine for
Stan? The default is \code{TRUE}. See \strong{Details}.}
}
\description{
Registers CmdStanR's knitr engine \code{\link[=eng_cmdstan]{eng_cmdstan()}} for processing Stan chunks.
Refer to the vignette
\href{https://mc-stan.org/cmdstanr/articles/r-markdown.html}{R Markdown CmdStan Engine}
for a demonstration.
}
\details{
If \code{override = TRUE} (default), this registers CmdStanR's knitr engine as the
engine for \code{stan} chunks, replacing knitr's built-in, RStan-based engine. If
\code{override = FALSE}, this registers a \code{cmdstan} engine so that both engines
may be used in the same R Markdown document. If the template supports syntax
highlighting for the Stan language, the \code{cmdstan} chunks will have \code{stan}
syntax highlighting applied to them.

See the vignette
\href{https://mc-stan.org/cmdstanr/articles/r-markdown.html}{R Markdown CmdStan Engine}
for an example.

\strong{Note:} When running chunks interactively in RStudio (e.g. when using
\href{https://bookdown.org/yihui/rmarkdown/notebook.html}{R Notebooks}), it has
been observed that the built-in, RStan-based engine is used for \code{stan}
chunks even when CmdStanR's engine has been registered in the session. When
the R Markdown document is knit/rendered, the correct engine is used. As a
workaround, when running chunks interactively, it is recommended to use the
\code{override = FALSE} option and change \code{stan} chunks to be \code{cmdstan} chunks.

If you would like to keep \code{stan} chunks as \code{stan} chunks, it is possible to
specify \code{engine = "cmdstan"} in the chunk options after registering the
\code{cmdstan} engine with \code{override = FALSE}.
}
\references{
\itemize{
\item \href{https://bookdown.org/yihui/rmarkdown-cookbook/custom-engine.html}{Register a custom language engine for knitr}
\item \href{https://bookdown.org/yihui/rmarkdown/language-engines.html#stan}{knitr's built-in Stan language engine}
}
}
