% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fit-method-lp}
\alias{fit-method-lp}
\alias{lp}
\alias{lp_approx}
\title{Extract log probability (target)}
\usage{
lp()

lp_approx()

lp_approx()
}
\value{
A numeric vector with length equal to the number of (post-warmup)
draws or length equal to \code{1} for optimization.
}
\description{
The \verb{$lp()} method extracts \code{lp__}, the total log probability
(\code{target}) accumulated in the model block of the Stan program. For
variational inference the log density of the variational approximation to
the posterior is available via the \verb{$lp_approx()} method. For
Laplace approximation the unnormalized density of the approximation to
the posterior is available via the \verb{$lp_approx()} method.

See the \href{https://mc-stan.org/docs/reference-manual/sampling-statements.html}{Log Probability Increment vs. Sampling Statement}
section of the Stan Reference Manual for details on when normalizing
constants are dropped from log probability calculations.
}
\section{Details}{

\code{lp__} is the unnormalized log density on Stan's \href{https://mc-stan.org/docs/2_23/reference-manual/variable-transforms-chapter.html}{unconstrained space}.
This will in general be different than the unnormalized model log density
evaluated at a posterior draw (which is on the constrained space). \code{lp__} is
intended to diagnose sampling efficiency and evaluate approximations.

For variational inference \code{lp_approx__} is the log density of the variational
approximation to \code{lp__} (also on the unconstrained space). It is exposed in
the variational method for performing the checks described in Yao et al.
(2018) and implemented in the \pkg{loo} package.

For Laplace approximation \code{lp_approx__} is the unnormalized density of the
Laplace approximation. It can be used to perform the same checks as in the
case of the variational method described in Yao et al. (2018).
}

\examples{
\dontrun{
fit_mcmc <- cmdstanr_example("logistic")
head(fit_mcmc$lp())

fit_mle <- cmdstanr_example("logistic", method = "optimize")
fit_mle$lp()

fit_vb <- cmdstanr_example("logistic", method = "variational")
plot(fit_vb$lp(), fit_vb$lp_approx())
}

}
\references{
Yao, Y., Vehtari, A., Simpson, D., and Gelman, A. (2018). Yes, but did it
work?: Evaluating variational inference. \emph{Proceedings of the 35th
International Conference on Machine Learning}, PMLR 80:5581–5590.
}
\seealso{
\code{\link{CmdStanMCMC}}, \code{\link{CmdStanMLE}}, \code{\link{CmdStanLaplace}}, \code{\link{CmdStanVB}}
}
