% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fit-method-diagnostic_summary}
\alias{fit-method-diagnostic_summary}
\alias{diagnostic_summary}
\title{Sampler diagnostic summaries and warnings}
\usage{
diagnostic_summary(
  diagnostics = c("divergences", "treedepth", "ebfmi"),
  quiet = FALSE
)
}
\arguments{
\item{diagnostics}{(character vector) One or more diagnostics to check. The
currently supported diagnostics are \verb{"divergences}, \code{"treedepth"}, and
\verb{"ebfmi}. The default is to check all of them.}

\item{quiet}{(logical) Should warning messages about the diagnostics be
suppressed? The default is \code{FALSE}, in which case warning messages are
printed in addition to returning the values of the diagnostics.}
}
\value{
A list with as many named elements as \code{diagnostics} selected. The
possible elements and their values are:
\itemize{
\item \code{"num_divergent"}: A vector of the number of divergences per chain.
\item \code{"num_max_treedepth"}: A vector of the number of times \code{max_treedepth} was hit per chain.
\item \code{"ebfmi"}: A vector of E-BFMI values per chain.
}
}
\description{
Warnings and summaries of sampler diagnostics. To instead get
the underlying values of the sampler diagnostics for each iteration and
chain use the \code{\link[=fit-method-sampler_diagnostics]{$sampler_diagnostics()}}
method.

Currently parameter-specific diagnostics like R-hat and effective sample
size are \emph{not} handled by this method. Those diagnostics are provided via
the \code{\link[=fit-method-summary]{$summary()}} method (using
\code{\link[posterior:draws_summary]{posterior::summarize_draws()}}).
}
\examples{
\dontrun{
fit <- cmdstanr_example("schools")
fit$diagnostic_summary()
fit$diagnostic_summary(quiet = TRUE)
}

}
\seealso{
\code{\link{CmdStanMCMC}} and the
\code{\link[=fit-method-sampler_diagnostics]{$sampler_diagnostics()}} method
}
