% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{model-method-laplace}
\alias{model-method-laplace}
\alias{laplace}
\title{Run Stan's Laplace algorithm}
\usage{
laplace(
  data = NULL,
  seed = NULL,
  refresh = NULL,
  init = NULL,
  save_latent_dynamics = FALSE,
  output_dir = getOption("cmdstanr_output_dir"),
  output_basename = NULL,
  sig_figs = NULL,
  threads = NULL,
  opencl_ids = NULL,
  mode = NULL,
  opt_args = NULL,
  jacobian = TRUE,
  draws = NULL,
  show_messages = TRUE,
  show_exceptions = TRUE,
  save_cmdstan_config = if (cmdstan_version() > "2.34.0") {
     TRUE
 } else {
    
    NULL
 }
)
}
\arguments{
\item{data}{(multiple options) The data to use for the variables specified in
the data block of the Stan program. One of the following:
\itemize{
\item A named list of \R objects with the names corresponding to variables
declared in the data block of the Stan program. Internally this list is
then written to JSON for CmdStan using \code{\link[=write_stan_json]{write_stan_json()}}. See
\code{\link[=write_stan_json]{write_stan_json()}} for details on the conversions performed on \R objects
before they are passed to Stan.
\item A path to a data file compatible with CmdStan (JSON or \R dump). See the
appendices in the CmdStan guide for details on using these formats.
\item \code{NULL} or an empty list if the Stan program has no data block.
}}

\item{seed}{(positive integer(s)) A seed for the (P)RNG to pass to CmdStan.
In the case of multi-chain sampling the single \code{seed} will automatically be
augmented by the the run (chain) ID so that each chain uses a different
seed. The exception is the transformed data block, which defaults to using
same seed for all chains so that the same data is generated for all chains
if RNG functions are used. The only time \code{seed} should be specified as a
vector (one element per chain) is if RNG functions are used in transformed
data and the goal is to generate \emph{different} data for each chain.}

\item{refresh}{(non-negative integer) The number of iterations between
printed screen updates. If \code{refresh = 0}, only error messages will be
printed.}

\item{init}{(multiple options) The initialization method to use for the
variables declared in the parameters block of the Stan program. One of the
following:
\itemize{
\item A real number \code{x>0}. This initializes \emph{all} parameters randomly between
\verb{[-x,x]} on the \emph{unconstrained} parameter space.;
\item The number \code{0}. This initializes \emph{all} parameters to \code{0};
\item A character vector of paths (one per chain) to JSON or Rdump files
containing initial values for all or some parameters. See
\code{\link[=write_stan_json]{write_stan_json()}} to write \R objects to JSON files compatible with
CmdStan.
\item A list of lists containing initial values for all or some parameters. For
MCMC the list should contain a sublist for each chain. For other model
fitting methods there should be just one sublist. The sublists should have
named elements corresponding to the parameters for which you are specifying
initial values. See \strong{Examples}.
\item A function that returns a single list with names corresponding to the
parameters for which you are specifying initial values. The function can
take no arguments or a single argument \code{chain_id}. For MCMC, if the
function has argument \code{chain_id} it will be supplied with the chain id
(from 1 to number of chains) when called to generate the initial values.
See
\strong{Examples}.
\item A \code{\link{CmdStanMCMC}}, \code{\link{CmdStanMLE}}, \code{\link{CmdStanVB}}, \code{\link{CmdStanPathfinder}},
or \code{\link{CmdStanLaplace}} fit object.
If the fit object's parameters are only a subset of the model
parameters then the other parameters will be drawn by Stan's default
initialization. The fit object must have at least some parameters that are the
same name and dimensions as the current Stan model. For the \code{sample} and
\code{pathfinder} method, if the fit object has fewer draws than the requested
number of chains/paths then the inits will be drawn using sampling with
replacement. Otherwise sampling without replacement will be used.
When a \code{\link{CmdStanPathfinder}} fit object is used as the init, if
. \code{psis_resample} was set to \code{FALSE} and \code{calculate_lp} was
set to \code{TRUE} (default), then resampling without replacement with Pareto
smoothed weights will be used. If \code{psis_resample} was set to \code{TRUE} or
\code{calculate_lp} was set to \code{FALSE} then sampling without replacement with
uniform weights will be used to select the draws.
PSIS resampling is used to select the draws for  \code{\link{CmdStanVB}},
and \code{\link{CmdStanLaplace}} fit objects.
\item A type inheriting from \code{posterior::draws}. If the draws object has less
samples than the number of requested chains/paths then the inits will be
drawn using sampling with replacement. Otherwise sampling without
replacement will be used. If the draws object's parameters are only a subset
of the model parameters then the other parameters will be drawn by Stan's
default initialization. The fit object must have at least some parameters
that are the same name and dimensions as the current Stan model.
}}

\item{save_latent_dynamics}{Ignored for this method.}

\item{output_dir}{(string) A path to a directory where CmdStan should write
its output CSV files. For MCMC there will be one file per chain; for other
methods there will be a single file. For interactive use this can typically
be left at \code{NULL} (temporary directory) since CmdStanR makes the CmdStan
output (posterior draws and diagnostics) available in \R via methods of the
fitted model objects. This can be set for an entire \R session using
\code{options(cmdstanr_output_dir)}. The behavior of \code{output_dir} is as follows:
\itemize{
\item If \code{NULL} (the default), then the CSV files are written to a temporary
directory and only saved permanently if the user calls one of the \verb{$save_*}
methods of the fitted model object (e.g.,
\code{\link[=fit-method-save_output_files]{$save_output_files()}}). These temporary
files are removed when the fitted model object is \link[base:gc]{garbage collected} (manually or automatically).
\item If a path, then the files are created in \code{output_dir} with names
corresponding to the defaults used by \verb{$save_output_files()}.
}}

\item{output_basename}{(string) A string to use as a prefix for the names of
the output CSV files of CmdStan. If \code{NULL} (the default), the basename of
the output CSV files will be comprised from the model name, timestamp, and
5 random characters.}

\item{sig_figs}{(positive integer) The number of significant figures used
when storing the output values. By default, CmdStan represent the output
values with 6 significant figures. The upper limit for \code{sig_figs} is 18.
Increasing this value will result in larger output CSV files and thus an
increased usage of disk space.}

\item{threads}{(positive integer) If the model was
\link[=model-method-compile]{compiled} with threading support, the number of
threads to use in parallelized sections (e.g., when
using the Stan functions \code{reduce_sum()} or \code{map_rect()}).}

\item{opencl_ids}{(integer vector of length 2) The platform and device IDs of
the OpenCL device to use for fitting. The model must be compiled with
\code{cpp_options = list(stan_opencl = TRUE)} for this argument to have an
effect.}

\item{mode}{(multiple options) The mode to center the approximation at. One
of the following:
\itemize{
\item A \code{\link{CmdStanMLE}} object from a previous run of \code{\link[=model-method-optimize]{$optimize()}}.
\item The path to a CmdStan CSV file from running optimization.
\item \code{NULL}, in which case \link[=model-method-optimize]{$optimize()} will be run
with \code{jacobian=jacobian} (see the \code{jacobian} argument below).
}

In all cases the total time reported by \code{\link[=fit-method-time]{$time()}} will be
the time of the Laplace sampling step only and does not include the time
taken to run the \verb{$optimize()} method.}

\item{opt_args}{(named list) A named list of optional arguments to pass to
\link[=model-method-optimize]{$optimize()} if \code{mode=NULL}.}

\item{jacobian}{(logical) Whether or not to enable the Jacobian adjustment
for constrained parameters. The default is \code{TRUE}. See the
\href{https://mc-stan.org/docs/cmdstan-guide/laplace-sampling.html}{Laplace Sampling}
section of the CmdStan User's Guide for more details. If \code{mode} is not
\code{NULL} then the value of \code{jacobian} must match the value used when
optimization was originally run. If \code{mode} is \code{NULL} then the value of
\code{jacobian} specified here is used when running optimization.}

\item{draws}{(positive integer) The number of draws to take.}

\item{show_messages}{(logical) When \code{TRUE} (the default), prints all output
during the execution process, such as iteration numbers and elapsed times.
If the output is silenced then the \code{\link[=fit-method-output]{$output()}} method
of the resulting fit object can be used to display the silenced messages.}

\item{show_exceptions}{(logical) When \code{TRUE} (the default), prints all
informational messages, for example rejection of the current proposal.
Disable if you wish to silence these messages, but this is not usually
recommended unless you are very confident that the model is correct up to
numerical error. If the messages are silenced then the
\code{\link[=fit-method-output]{$output()}} method of the resulting fit object can be
used to display the silenced messages.}

\item{save_cmdstan_config}{(logical) When \code{TRUE} (the default), call CmdStan
with argument \code{"output save_config=1"} to save a json file which contains
the argument tree and extra information (equivalent to the output CSV file
header). This option is only available in CmdStan 2.34.0 and later.}
}
\value{
A \code{\link{CmdStanLaplace}} object.
}
\description{
The \verb{$laplace()} method of a \code{\link{CmdStanModel}} object produces a
sample from a normal approximation centered at the mode of a distribution
in the unconstrained space. If the mode is a maximum a posteriori (MAP)
estimate, the samples provide an estimate of the mean and standard
deviation of the posterior distribution. If the mode is a maximum
likelihood estimate (MLE), the sample provides an estimate of the standard
error of the likelihood. Whether the mode is the MAP or MLE depends on
the value of the \code{jacobian} argument when running optimization. See the
\href{https://mc-stan.org/docs/cmdstan-guide/}{CmdStan User’s Guide}
for more details.

Any argument left as \code{NULL} will default to the default value used by the
installed version of CmdStan.
}
\examples{
\dontrun{
file <- file.path(cmdstan_path(), "examples/bernoulli/bernoulli.stan")
mod <- cmdstan_model(file)
mod$print()

stan_data <- list(N = 10, y = c(0,1,0,0,0,0,0,0,0,1))
fit_mode <- mod$optimize(data = stan_data, jacobian = TRUE)
fit_laplace <- mod$laplace(data = stan_data, mode = fit_mode)
fit_laplace$summary()

# if mode isn't specified optimize is run internally first
fit_laplace <- mod$laplace(data = stan_data)
fit_laplace$summary()

# plot approximate posterior
bayesplot::mcmc_hist(fit_laplace$draws("theta"))
}


}
\seealso{
The CmdStanR website
(\href{https://mc-stan.org/cmdstanr/}{mc-stan.org/cmdstanr}) for online
documentation and tutorials.

The Stan and CmdStan documentation:
\itemize{
\item Stan documentation: \href{https://mc-stan.org/users/documentation/}{mc-stan.org/users/documentation}
\item CmdStan User’s Guide: \href{https://mc-stan.org/docs/cmdstan-guide/}{mc-stan.org/docs/cmdstan-guide}
}

Other CmdStanModel methods: 
\code{\link{model-method-check_syntax}},
\code{\link{model-method-compile}},
\code{\link{model-method-diagnose}},
\code{\link{model-method-expose_functions}},
\code{\link{model-method-format}},
\code{\link{model-method-generate-quantities}},
\code{\link{model-method-optimize}},
\code{\link{model-method-pathfinder}},
\code{\link{model-method-sample}},
\code{\link{model-method-sample_mpi}},
\code{\link{model-method-variables}},
\code{\link{model-method-variational}}
}
\concept{CmdStanModel methods}
