% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fit-method-loo}
\alias{fit-method-loo}
\alias{loo}
\title{Leave-one-out cross-validation (LOO-CV)}
\usage{
loo(variables = "log_lik", r_eff = TRUE, moment_match = FALSE, ...)
}
\arguments{
\item{variables}{(character vector) The name(s) of the variable(s) in the
Stan program containing the pointwise log-likelihood. The default is to
look for \code{"log_lik"}. This argument is passed to the
\code{\link[=fit-method-draws]{$draws()}} method.}

\item{r_eff}{(multiple options) How to handle the \code{r_eff} argument for \code{loo()}:
\itemize{
\item \code{TRUE} (the default) will automatically call \code{\link[loo:relative_eff]{loo::relative_eff.array()}}
to compute the \code{r_eff} argument to pass to \code{\link[loo:loo]{loo::loo.array()}}.
\item \code{FALSE} or \code{NULL} will avoid computing \code{r_eff} (which can sometimes be slow),
but the reported ESS and MCSE estimates can be over-optimistic if the
posterior draws are not (near) independent.
\item If \code{r_eff} is anything else, that object will be passed as the \code{r_eff}
argument to \code{\link[loo:loo]{loo::loo.array()}}.
}}

\item{moment_match}{(logical) Whether to use a
\link[loo:loo_moment_match]{moment-matching} correction for problematic
observations. The default is \code{FALSE}. Using \code{moment_match=TRUE} will result
in compiling the additional methods described in
\link{fit-method-init_model_methods}. This allows CmdStanR to automatically
supply the functions for the \code{log_lik_i}, \code{unconstrain_pars},
\code{log_prob_upars}, and \code{log_lik_i_upars} arguments to
\code{\link[loo:loo_moment_match]{loo::loo_moment_match()}}.}

\item{...}{Other arguments (e.g., \code{cores}, \code{save_psis}, etc.) passed to
\code{\link[loo:loo]{loo::loo.array()}} or \code{\link[loo:loo_moment_match]{loo::loo_moment_match.default()}}
(if \code{moment_match} = \code{TRUE} is set).}
}
\value{
The object returned by \code{\link[loo:loo]{loo::loo.array()}} or
\code{\link[loo:loo_moment_match]{loo::loo_moment_match.default()}}.
}
\description{
The \verb{$loo()} method computes approximate LOO-CV using the
\pkg{loo} package. In order to use this method you must compute and save
the pointwise log-likelihood in your Stan program. See \code{\link[loo:loo]{loo::loo.array()}}
and the \pkg{loo} package \href{https://mc-stan.org/loo/articles/}{vignettes}
for details.
}
\examples{

\dontrun{
# the "logistic" example model has "log_lik" in generated quantities
fit <- cmdstanr_example("logistic")
loo_result <- fit$loo(cores = 2)
print(loo_result)
}

}
\seealso{
The \pkg{loo} package website with
\href{https://mc-stan.org/loo/reference/index.html}{documentation} and
\href{https://mc-stan.org/loo/articles/}{vignettes}.
}
