% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fit-method-constrain_variables}
\alias{fit-method-constrain_variables}
\alias{constrain_variables}
\title{Transform a set of unconstrained parameter values to the constrained scale}
\usage{
constrain_variables(
  unconstrained_variables,
  transformed_parameters = TRUE,
  generated_quantities = TRUE
)
}
\arguments{
\item{unconstrained_variables}{(numeric) A vector of unconstrained parameters
to constrain.}

\item{transformed_parameters}{(boolean) Whether to return transformed
parameters implied by newly-constrained parameters (defaults to TRUE).}

\item{generated_quantities}{(boolean) Whether to return generated quantities
implied by newly-constrained parameters (defaults to TRUE).}
}
\description{
The \verb{$constrain_variables()} method transforms input parameters to
the constrained scale
}
\examples{
\dontrun{
fit_mcmc <- cmdstanr_example("logistic", method = "sample")
fit_mcmc$init_model_methods()
fit_mcmc$constrain_variables(unconstrained_variables = c(0.5, 1.2, 1.1, 2.2))
}

}
\seealso{
\code{\link[=log_prob]{log_prob()}}, \code{\link[=grad_log_prob]{grad_log_prob()}}, \code{\link[=constrain_variables]{constrain_variables()}},
\code{\link[=unconstrain_variables]{unconstrain_variables()}}, \code{\link[=unconstrain_draws]{unconstrain_draws()}}, \code{\link[=variable_skeleton]{variable_skeleton()}},
\code{\link[=hessian]{hessian()}}
}
