% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{as_mcmc.list}
\alias{as_mcmc.list}
\title{Convert \code{CmdStanMCMC} to \code{mcmc.list}}
\usage{
as_mcmc.list(x)
}
\arguments{
\item{x}{A \link{CmdStanMCMC} object.}
}
\value{
An \code{mcmc.list} object compatible with the \pkg{coda} package.
}
\description{
This function converts a \code{CmdStanMCMC} object to an \code{mcmc.list} object
compatible with the \pkg{coda} package. This is primarily intended for users
of Stan coming from BUGS/JAGS who are used to \pkg{coda} for plotting and
diagnostics. In general we recommend the more recent MCMC diagnostics in
\pkg{posterior} and the \pkg{ggplot2}-based plotting functions in
\pkg{bayesplot}, but for users who prefer \pkg{coda} this function provides
compatibility.
}
\examples{
\dontrun{
fit <- cmdstanr_example()
x <- as_mcmc.list(fit)
}

}
