% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{CmdStanGQ}
\alias{CmdStanGQ}
\title{CmdStanGQ objects}
\description{
A \code{CmdStanGQ} object is the fitted model object returned by the
\code{\link[=model-method-generate-quantities]{$generate_quantities()}} method of a
\code{\link{CmdStanModel}} object.
}
\section{Methods}{
 \code{CmdStanGQ} objects have the following associated methods,
all of which have their own (linked) documentation pages.
\subsection{Extract contents of generated quantities object}{\tabular{ll}{
   \strong{Method} \tab \strong{Description} \cr
   \code{\link[=fit-method-draws]{$draws()}} \tab Return the generated quantities as a \code{\link[posterior:draws_array]{draws_array}}. \cr
   \code{\link[=fit-method-metadata]{$metadata()}} \tab Return a list of metadata gathered from the CmdStan CSV files. \cr
   \code{\link[=fit-method-code]{$code()}} \tab Return Stan code as a character vector. \cr
}

}

\subsection{Summarize inferences}{\tabular{ll}{
   \strong{Method} \tab \strong{Description} \cr
   \code{\link[=fit-method-summary]{$summary()}} \tab Run \code{\link[posterior:draws_summary]{posterior::summarise_draws()}}. \cr
}

}

\subsection{Save fitted model object and temporary files}{\tabular{ll}{
   \strong{Method} \tab \strong{Description} \cr
   \code{\link[=fit-method-save_object]{$save_object()}} \tab Save fitted model object to a file. \cr
   \code{\link[=fit-method-save_output_files]{$save_output_files()}} \tab Save output CSV files to a specified location. \cr
   \code{\link[=fit-method-save_data_file]{$save_data_file()}} \tab Save JSON data file to a specified location. \cr
}

}

\subsection{Report run times, console output, return codes}{\tabular{ll}{
   \strong{Method} \tab \strong{Description} \cr
   \code{\link[=fit-method-time]{$time()}} \tab Report the total run time. \cr
   \code{\link[=fit-method-output]{$output()}} \tab Return the stdout and stderr of all chains or pretty print the output for a single chain. \cr
   \code{\link[=fit-method-return_codes]{$return_codes()}} \tab Return the return codes from the CmdStan runs. \cr
}

}
}

\examples{
\dontrun{
# first fit a model using MCMC
mcmc_program <- write_stan_file(
  "data {
    int<lower=0> N;
    int<lower=0,upper=1> y[N];
  }
  parameters {
    real<lower=0,upper=1> theta;
  }
  model {
    y ~ bernoulli(theta);
  }"
)
mod_mcmc <- cmdstan_model(mcmc_program)

data <- list(N = 10, y = c(1,1,0,0,0,1,0,1,0,0))
fit_mcmc <- mod_mcmc$sample(data = data, seed = 123, refresh = 0)

# stan program for standalone generated quantities
# (could keep model block, but not necessary so removing it)
gq_program <- write_stan_file(
  "data {
    int<lower=0> N;
    int<lower=0,upper=1> y[N];
  }
  parameters {
    real<lower=0,upper=1> theta;
  }
  generated quantities {
    int y_rep[N] = bernoulli_rng(rep_vector(theta, N));
  }"
)

mod_gq <- cmdstan_model(gq_program)
fit_gq <- mod_gq$generate_quantities(fit_mcmc, data = data, seed = 123)
str(fit_gq$draws())

library(posterior)
as_draws_df(fit_gq$draws())
}

}
\seealso{
The CmdStanR website
(\href{https://mc-stan.org/cmdstanr/}{mc-stan.org/cmdstanr}) for online
documentation and tutorials.

The Stan and CmdStan documentation:
\itemize{
\item Stan documentation: \href{https://mc-stan.org/users/documentation/}{mc-stan.org/users/documentation}
\item CmdStan User’s Guide: \href{https://mc-stan.org/docs/cmdstan-guide/}{mc-stan.org/docs/cmdstan-guide}
}

Other fitted model objects: 
\code{\link{CmdStanDiagnose}},
\code{\link{CmdStanMCMC}},
\code{\link{CmdStanMLE}},
\code{\link{CmdStanVB}}
}
\concept{fitted model objects}
