% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fit-method-metadata}
\alias{fit-method-metadata}
\alias{metadata}
\title{Extract metadata from CmdStan CSV files}
\usage{
metadata()
}
\description{
The \verb{$metadata()} method returns a list of information gathered
from the CSV output files, including the CmdStan configuration used when
fitting the model. See \strong{Examples} and \code{\link[=read_cmdstan_csv]{read_cmdstan_csv()}}.
}
\examples{
\dontrun{
fit_mcmc <- cmdstanr_example("logistic", method = "sample")
str(fit_mcmc$metadata())

fit_mle <- cmdstanr_example("logistic", method = "optimize")
str(fit_mle$metadata())

fit_vb <- cmdstanr_example("logistic", method = "variational")
str(fit_vb$metadata())
}

}
\seealso{
\code{\link{CmdStanMCMC}}, \code{\link{CmdStanMLE}}, \code{\link{CmdStanVB}}, \code{\link{CmdStanGQ}}
}
