% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tps.R
\name{create_bivariate_design}
\alias{create_bivariate_design}
\title{Creates a design matrix from a bivariate smoothing algorithm}
\usage{
create_bivariate_design(X1, X2, num_knots = NULL, knots = NULL)
}
\arguments{
\item{X1}{numeric vector for first variable}

\item{X2}{numeric vector for second variable}

\item{num_knots}{optional: number of knots}

\item{knots}{optional: matrix of knot locations for bivariate smoothing}
}
\value{
list containing the design matrix \code{Z} and matrix of \code{knots}
}
\description{
\code{create_bivariate_design} accepts two numeric vectors of equal length as inputs. From these inputs, a bivariate smoothing design matrix is produced using thin plate splines.
}
\examples{
x1 <- rnorm(100)
x2 <- rnorm(100)
res <- create_bivariate_design(x1, x2)
res$knots
dim(res$Z)
}
\references{
Ruppert, David, Matt P. Wand, and Raymond J. Carroll. \emph{Semiparametric Regression}. No. 12. Cambridge university press, 2003. Section 13.5

Matt Wand (2018). SemiPar: Semiparametric Regression. R package version 1.0-4.2.
}
