% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_lme.R
\name{augment.graph_lme}
\alias{augment.graph_lme}
\alias{augment}
\title{Augment data with information from a \code{graph_lme} object}
\usage{
\method{augment}{graph_lme}(
  x,
  newdata = NULL,
  which_repl = NULL,
  se_fit = FALSE,
  conf_int = FALSE,
  pred_int = FALSE,
  level = 0.95,
  n_samples = 100,
  edge_number = "edge_number",
  distance_on_edge = "distance_on_edge",
  coord_x = "coord_x",
  coord_y = "coord_y",
  data_coords = c("PtE", "spatial"),
  normalized = FALSE,
  ...
)
}
\arguments{
\item{x}{A \code{graph_lme} object.}

\item{newdata}{A \code{data.frame} or a \code{list} containing the covariates, the edge
number and the distance on edge for the locations to obtain the prediction. If \code{NULL}, the fitted values will be given for the original locations where the model was fitted.}

\item{which_repl}{Which replicates to obtain the prediction. If \code{NULL} predictions
will be obtained for all replicates. Default is \code{NULL}.}

\item{se_fit}{Logical indicating whether or not a .se.fit column should be added to the augmented output. If TRUE, it only returns a non-NA value if type of prediction is 'link'.}

\item{conf_int}{Logical indicating whether or not confidence intervals for the fitted variable should be built.}

\item{pred_int}{Logical indicating whether or not prediction intervals for future observations should be built.}

\item{level}{Level of confidence and prediction intervals if they are constructed.}

\item{n_samples}{Number of samples when computing prediction intervals.}

\item{edge_number}{Name of the variable that contains the edge number, the
default is \code{edge_number}.}

\item{distance_on_edge}{Name of the variable that contains the distance on
edge, the default is \code{distance_on_edge}.}

\item{coord_x}{Column (or entry on the list) of the \code{data} that contains
the x coordinate. If not supplied, the column with name "coord_x" will be
chosen. Will not be used if \code{Spoints} is not \code{NULL} or if \code{data_coords} is
\code{PtE}.}

\item{coord_y}{Column (or entry on the list) of the \code{data} that contains
the y coordinate. If not supplied, the column with name "coord_x" will be
chosen. Will not be used if \code{Spoints} is not \code{NULL} or if \code{data_coords} is
\code{PtE}.}

\item{data_coords}{To be used only if \code{Spoints} is \code{NULL}. It decides which
coordinate system to use. If \code{PtE}, the user must provide \code{edge_number} and
\code{distance_on_edge}, otherwise if \code{spatial}, the user must provide
\code{coord_x} and \code{coord_y}.}

\item{normalized}{Are the distances on edges normalized?}

\item{...}{Additional arguments.}
}
\value{
A \code{\link[tidyr:reexports]{tidyr::tibble()}} with columns:
\itemize{
\item \code{.fitted} Fitted or predicted value.
\item \code{.fittedlwrconf} Lower bound of the confidence interval, if conf_int = TRUE
\item \code{.fitteduprconf} Upper bound of the confidence interval, if conf_int = TRUE
\item \code{.fittedlwrpred} Lower bound of the prediction interval, if pred_int = TRUE
\item \code{.fitteduprpred} Upper bound of the prediction interval, if pred_int = TRUE
\item \code{.fixed} Prediction of the fixed effects.
\item \code{.random} Prediction of the random effects.
\item \code{.resid} The ordinary residuals, that is, the difference between observed and fitted values.
\item \code{.se_fit} Standard errors of fitted values, if se_fit = TRUE.
}
}
\description{
Augment accepts a model object and a dataset and adds information about each observation in the dataset. It includes
predicted values in the \code{.fitted} column, residuals in the \code{.resid} column, and standard errors for the fitted values in a \code{.se.fit} column.
It also contains the New columns always begin with a . prefix to avoid overwriting columns in the original dataset.
}
\seealso{
\link{glance.graph_lme}
}
