//// [tests/cases/compiler/invariantGenericErrorElaboration.ts] ////

//// [invariantGenericErrorElaboration.ts]
// Repro from #19746

const wat: Runtype<any> = Num;
const Foo = Obj({ foo: Num })

interface Runtype<A> {
  constraint: Constraint<this>
  witness: A
}

interface Num extends Runtype<number> {
  tag: 'number'
}
declare const Num: Num

interface Obj<O extends { [_ in string]: Runtype<any> }> extends Runtype<{[K in keyof O]: O[K]['witness'] }> {}
declare function Obj<O extends { [_: string]: Runtype<any> }>(fields: O): Obj<O>;

interface Constraint<A extends Runtype<any>> extends Runtype<A['witness']> {
  underlying: A,
  check: (x: A['witness']) => void,
}


//// [invariantGenericErrorElaboration.js]
"use strict";
// Repro from #19746
var wat = Num;
var Foo = Obj({ foo: Num });
