# Jasmine Core 5.0.0 Release Notes

## Summary

This is a major release that includes breaking changes. It primarily adds
support for parallel execution in Node via the `jasmine` package. Most users
should be able to upgrade without changes, but please read the list of breaking
changes below and see the [migration guide](https://jasmine.github.io/tutorials/upgrading_to_Jasmine_5.0)
for more information.

## Breaking changes

* Dropped support for Node 12, 14, and 16
* Dropped support for Safari 14 and Firefox 91
* Made Env#execute async and removed the callback parameter
* Global errors are detected via addEventListener rather than setting window.onerror
* The `boot` function exported by the core module returns the same object
  every time it's called.
* Removed node_boot.js. Use the exported `boot` function instead.

## New features

* Support for parallel execution in Node via the `jasmine` package
  See the [parallel guide](https://jasmine.github.io/tutorials/running_specs_in_parallel) 
  for more information.
* Added Node 20 to supported environments

## Bug fixes

* Accessibility: Always provide a non-color indication that a spec is pending
* Accessibility: Improved contrast of version number and inactive tab links
* Uninstall the global error handler at the end of env execution

## Internal improvements

* Updated dev dependencies
* Dogfood parallel execution feature in CI

## Supported environments

jasmine-core 5.0.0 has been tested in the following environments.

| Environment       | Supported versions |
|-------------------|--------------------|
| Node              | 18, 20             |
| Safari            | 15-16              |
| Chrome            | 113                |
| Firefox           | 102, 113           |
| Edge              | 113                |



------

_Release Notes generated with _[Anchorman](http://github.com/infews/anchorman)_
