#define DEFAULTGOP_B -1530
#define DEFAULTGEP_B   -00 
#define DEFAULTOFS_B  -123   /* +10 -- -50  teido ka ? */


void BLOSUMmtx( int n, double **matrix, double *freq, unsigned char *amino, char *amino_grp, int *rescalept )
{
	/*
	char locaminod[26] = "GASTPLIMVDNEQFYWKRHCXXX.-U";
	*/
//	char locaminod[] = "ARNDCQEGHILKMFPSTWYVBZX.-U";
	char locaminod[] = "ARNDCQEGHILKMFPSTWYVBZX.-J";
	char locgrpd[] = 
	{
		0, 3, 2, 2, 5, 2, 2, 0, 3, 1, 1, 3, 1, 4, 0, 0, 0, 4, 4, 1, 2, 2,
		6, 6, 6, 1,
	};
	double freqd[20] = 
	{
	    0.077,
	    0.051,
	    0.043,
	    0.052,
	    0.020,
	    0.041,
	    0.062,
	    0.074,
	    0.023,
	    0.052,
	    0.091,
	    0.059,
	    0.024,
	    0.040,
	    0.051,
	    0.069,
	    0.059,
	    0.014,
	    0.032,
	    0.066,
	};

	double tmpmtx30[] = 
	{
    4,
   -1,     8,
    0,    -2,     8,
    0,    -1,     1,     9,
   -3,    -2,    -1,    -3,    17,
    1,     3,    -1,    -1,    -2,     8,
    0,    -1,    -1,     1,     1,     2,     6,
    0,    -2,     0,    -1,    -4,    -2,    -2,     8,
   -2,    -1,    -1,    -2,    -5,     0,     0,    -3,    14,
    0,    -3,     0,    -4,    -2,    -2,    -3,    -1,    -2,     6,
   -1,    -2,    -2,    -1,     0,    -2,    -1,    -2,    -1,     2,     4,
    0,     1,     0,     0,    -3,     0,     2,    -1,    -2,    -2,    -2,     4,
    1,     0,     0,    -3,    -2,    -1,    -1,    -2,     2,     1,     2,     2,     6,
   -2,    -1,    -1,    -5,    -3,    -3,    -4,    -3,    -3,     0,     2,    -1,    -2,    10,
   -1,    -1,    -3,    -1,    -3,     0,     1,    -1,     1,    -3,    -3,     1,    -4,    -4,    11,
    1,    -1,     0,     0,    -2,    -1,     0,     0,    -1,    -1,    -2,     0,    -2,    -1,    -1,     4,
    1,    -3,     1,    -1,    -2,     0,    -2,    -2,    -2,     0,     0,    -1,     0,    -2,     0,     2,     5,
   -5,     0,    -7,    -4,    -2,    -1,    -1,     1,    -5,    -3,    -2,    -2,    -3,     1,    -3,    -3,    -5,    20,
   -4,     0,    -4,    -1,    -6,    -1,    -2,    -3,     0,    -1,     3,    -1,    -1,     3,    -2,    -2,    -1,     5,     9,
    1,    -1,    -2,    -2,    -2,    -3,    -3,    -3,    -3,     4,     1,    -2,     0,     1,    -4,    -1,     1,    -3,     1,     5,
    0,    -2,     4,     5,    -2,    -1,     0,     0,    -2,    -2,    -1,     0,    -2,    -3,    -2,     0,     0,    -5,    -3,    -2,     5,
    0,     0,    -1,     0,     0,     4,     5,    -2,     0,    -3,    -1,     1,    -1,    -4,     0,    -1,    -1,    -1,    -2,    -3,     0,     4,
    0,    -1,     0,    -1,    -2,     0,    -1,    -1,    -1,     0,     0,     0,     0,    -1,    -1,     0,     0,    -2,    -1,     0,    -1,     0,    -1,
	};
	
	double tmpmtx45[] = 
	{
      5,
     -2,      7,
     -1,      0,      6,
     -2,     -1,      2,      7,
     -1,     -3,     -2,     -3,     12,
     -1,      1,      0,      0,     -3,      6,
     -1,      0,      0,      2,     -3,      2,      6,
      0,     -2,      0,     -1,     -3,     -2,     -2,      7,
     -2,      0,      1,      0,     -3,      1,      0,     -2,     10,
     -1,     -3,     -2,     -4,     -3,     -2,     -3,     -4,     -3,      5,
     -1,     -2,     -3,     -3,     -2,     -2,     -2,     -3,     -2,      2,      5,
     -1,      3,      0,      0,     -3,      1,      1,     -2,     -1,     -3,     -3,      5,
     -1,     -1,     -2,     -3,     -2,      0,     -2,     -2,      0,      2,      2,     -1,      6,
     -2,     -2,     -2,     -4,     -2,     -4,     -3,     -3,     -2,      0,      1,     -3,      0,      8,
     -1,     -2,     -2,     -1,     -4,     -1,      0,     -2,     -2,     -2,     -3,     -1,     -2,     -3,      9,
      1,     -1,      1,      0,     -1,      0,      0,      0,     -1,     -2,     -3,     -1,     -2,     -2,     -1,      4,
      0,     -1,      0,     -1,     -1,     -1,     -1,     -2,     -2,     -1,     -1,     -1,     -1,     -1,     -1,      2,      5,
     -2,     -2,     -4,     -4,     -5,     -2,     -3,     -2,     -3,     -2,     -2,     -2,     -2,      1,     -3,     -4,     -3,     15,
     -2,     -1,     -2,     -2,     -3,     -1,     -2,     -3,      2,      0,      0,     -1,      0,      3,     -3,     -2,     -1,      3,      8,
      0,     -2,     -3,     -3,     -1,     -3,     -3,     -3,     -3,      3,      1,     -2,      1,      0,     -3,     -1,      0,     -3,     -1,      5,
	};
    double tmpmtx50[] = 
    {
       5,
      -2,      7,
      -1,     -1,      7,
      -2,     -2,      2,      8,
      -1,     -4,     -2,     -4,     13,
      -1,      1,      0,      0,     -3,      7,
      -1,      0,      0,      2,     -3,      2,      6,
       0,     -3,      0,     -1,     -3,     -2,     -3,      8,
      -2,      0,      1,     -1,     -3,      1,      0,     -2,     10,
      -1,     -4,     -3,     -4,     -2,     -3,     -4,     -4,     -4,      5,
      -2,     -3,     -4,     -4,     -2,     -2,     -3,     -4,     -3,      2,      5,
      -1,      3,      0,     -1,     -3,      2,      1,     -2,      0,     -3,     -3,      6,
      -1,     -2,     -2,     -4,     -2,      0,     -2,     -3,     -1,      2,      3,     -2,      7,
      -3,     -3,     -4,     -5,     -2,     -4,     -3,     -4,     -1,      0,      1,     -4,      0,      8,
      -1,     -3,     -2,     -1,     -4,     -1,     -1,     -2,     -2,     -3,     -4,     -1,     -3,     -4,     10,
       1,     -1,      1,      0,     -1,      0,     -1,      0,     -1,     -3,     -3,      0,     -2,     -3,     -1,      5,
       0,     -1,      0,     -1,     -1,     -1,     -1,     -2,     -2,     -1,     -1,     -1,     -1,     -2,     -1,      2,      5,
      -3,     -3,     -4,     -5,     -5,     -1,     -3,     -3,     -3,     -3,     -2,     -3,     -1,      1,     -4,     -4,     -3,     15,
      -2,     -1,     -2,     -3,     -3,     -1,     -2,     -3,      2,     -1,     -1,     -2,      0,      4,     -3,     -2,     -2,      2,      8,
       0,     -3,     -3,     -4,     -1,     -3,     -3,     -4,     -4,      4,      1,     -3,      1,     -1,     -3,     -2,      0,     -3,     -1,      5,
    };
#if 0
	double tmpmtx62[] = 
	{
      6,
     -2,      8,
     -2,     -1,      8,
     -3,     -2,      2,      9,
     -1,     -5,     -4,     -5,     13,
     -1,      1,      0,      0,     -4,      8,
     -1,      0,      0,      2,     -5,      3,      7,
      0,     -3,     -1,     -2,     -4,     -3,     -3,      8,
     -2,      0,      1,     -2,     -4,      1,      0,     -3,     11,
     -2,     -4,     -5,     -5,     -2,     -4,     -5,     -6,     -5,      6,
     -2,     -3,     -5,     -5,     -2,     -3,     -4,     -5,     -4,      2,      6,
     -1,      3,      0,     -1,     -5,      2,      1,     -2,     -1,     -4,     -4,      7,
     -1,     -2,     -3,     -5,     -2,     -1,     -3,     -4,     -2,      2,      3,     -2,      8,
     -3,     -4,     -4,     -5,     -4,     -5,     -5,     -5,     -2,      0,      1,     -5,      0,      9,
     -1,     -3,     -3,     -2,     -4,     -2,     -2,     -3,     -3,     -4,     -4,     -2,     -4,     -5,     11,
      2,     -1,      1,      0,     -1,      0,      0,      0,     -1,     -4,     -4,      0,     -2,     -4,     -1,      6,
      0,     -2,      0,     -2,     -1,     -1,     -1,     -2,     -3,     -1,     -2,     -1,     -1,     -3,     -2,      2,      7,
     -4,     -4,     -6,     -6,     -3,     -3,     -4,     -4,     -4,     -4,     -2,     -4,     -2,      1,     -5,     -4,     -4,     16,
     -3,     -3,     -3,     -5,     -4,     -2,     -3,     -5,      3,     -2,     -2,     -3,     -1,      4,     -4,     -3,     -2,      3,     10,
      0,     -4,     -4,     -5,     -1,     -3,     -4,     -5,     -5,      4,      1,     -3,      1,     -1,     -4,     -2,      0,     -4,     -2,      6,
	};
#else
	double tmpmtx62[] = 
	{ 5.893685,
	 -2.120252,  8.210189,
	 -2.296072, -0.659672,  8.479856,
	 -2.630151, -2.408668,  1.907550,  8.661363,
	 -0.612761, -5.083814, -3.989626, -5.189966, 12.873172,
	 -1.206025,  1.474162,  0.002529, -0.470069, -4.352838,  7.927704,
	 -1.295821, -0.173087, -0.402015,  2.265459, -5.418729,  2.781955,  7.354247,
	  0.239392, -3.456163, -0.634136, -1.970281, -3.750621, -2.677743, -3.165266,  8.344902,
	 -2.437724, -0.374792,  0.867735, -1.678363, -4.481724,  0.672051, -0.176497, -3.061315, 11.266586,
	 -1.982718, -4.485360, -4.825558, -4.681732, -1.841495, -4.154454, -4.791538, -5.587336, -4.847345,  5.997760,
	 -2.196882, -3.231860, -5.068375, -5.408471, -1.916207, -3.200863, -4.269723, -5.440437, -4.180099,  2.282412,  5.774148,
	 -1.101017,  3.163105, -0.268534, -1.052724, -4.554510,  1.908859,  1.163010, -2.291924, -1.081539, -4.005209, -3.670219,  6.756827,
	 -1.402897, -2.050705, -3.226290, -4.587785, -2.129758, -0.631437, -2.997038, -4.014898, -2.326896,  1.690191,  2.987638, -2.032119,  8.088951,
	 -3.315080, -4.179521, -4.491005, -5.225795, -3.563219, -4.746598, -4.788639, -4.661029, -1.851231, -0.241317,  0.622170, -4.618016,  0.018880,  9.069126,
	 -1.221394, -3.162863, -3.000581, -2.220163, -4.192770, -1.922917, -1.674258, -3.200320, -3.241363, -4.135001, -4.290107, -1.520445, -3.714633, -5.395930, 11.046892,
	  1.673639, -1.147170,  0.901353, -0.391548, -1.312485, -0.151708, -0.220375, -0.438748, -1.322366, -3.522266, -3.663923, -0.305170, -2.221304, -3.553533, -1.213470,  5.826527,
	 -0.068042, -1.683495, -0.069138, -1.576054, -1.299983, -1.012997, -1.294878, -2.363065, -2.528844, -1.076382, -1.796229, -1.004336, -0.999449, -3.161436, -1.612919,  2.071710,  6.817956,
	 -3.790328, -4.019108, -5.543911, -6.321502, -3.456164, -2.919725, -4.253197, -3.737232, -3.513238, -3.870811, -2.447829, -4.434676, -2.137255,  1.376341, -5.481260, -4.127804, -3.643382, 15.756041,
	 -2.646022, -2.540799, -3.122641, -4.597428, -3.610671, -2.131601, -3.030688, -4.559647,  2.538948, -1.997058, -1.593097, -2.730047, -1.492308,  4.408690, -4.379667, -2.528713, -2.408996,  3.231335,  9.892544,
	 -0.284140, -3.753871, -4.314525, -4.713963, -1.211518, -3.297575, -3.663425, -4.708118, -4.676220,  3.820569,  1.182672, -3.393535,  1.030861, -1.273542, -3.523054, -2.469318, -0.083276, -4.251392, -1.811267,  5.653391,
	};
#endif
	double tmpmtx80[] = 
	{
      7,
     -3,      9,
     -3,     -1,      9,
     -3,     -3,      2,     10,
     -1,     -6,     -5,     -7,     13,
     -2,      1,      0,     -1,     -5,      9,
     -2,     -1,     -1,      2,     -7,      3,      8,
      0,     -4,     -1,     -3,     -6,     -4,     -4,      9,
     -3,      0,      1,     -2,     -7,      1,      0,     -4,     12,
     -3,     -5,     -6,     -7,     -2,     -5,     -6,     -7,     -6,      7,
     -3,     -4,     -6,     -7,     -3,     -4,     -6,     -7,     -5,      2,      6,
     -1,      3,      0,     -2,     -6,      2,      1,     -3,     -1,     -5,     -4,      8,
     -2,     -3,     -4,     -6,     -3,     -1,     -4,     -5,     -4,      2,      3,     -3,      9,
     -4,     -5,     -6,     -6,     -4,     -5,     -6,     -6,     -2,     -1,      0,     -5,      0,     10,
     -1,     -3,     -4,     -3,     -6,     -3,     -2,     -5,     -4,     -5,     -5,     -2,     -4,     -6,     12,
      2,     -2,      1,     -1,     -2,     -1,     -1,     -1,     -2,     -4,     -4,     -1,     -3,     -4,     -2,      7,
      0,     -2,      0,     -2,     -2,     -1,     -2,     -3,     -3,     -2,     -3,     -1,     -1,     -4,     -3,      2,      8,
     -5,     -5,     -7,     -8,     -5,     -4,     -6,     -6,     -4,     -5,     -4,     -6,     -3,      0,     -7,     -6,     -5,     16,
     -4,     -4,     -4,     -6,     -5,     -3,     -5,     -6,      3,     -3,     -2,     -4,     -3,      4,     -6,     -3,     -3,      3,     11,
     -1,     -4,     -5,     -6,     -2,     -4,     -4,     -6,     -5,      4,      1,     -4,      1,     -2,     -4,     -3,      0,     -5,     -3,      7,
	};
	double tmpmtx90[] = 
	{
 5,
-2,  6,
-2, -1,  7,
-3, -3,  1,  7,
-1, -5, -4, -5,  9,
-1,  1,  0, -1, -4,  7,
-1, -1, -1,  1, -6,  2,  6,
 0, -3, -1, -2, -4, -3, -3,  6,
-2,  0,  0, -2, -5,  1, -1, -3,  8,
-2, -4, -4, -5, -2, -4, -4, -5, -4,  5,
-2, -3, -4, -5, -2, -3, -4, -5, -4,  1,  5,
-1,  2,  0, -1, -4,  1,  0, -2, -1, -4, -3,  6,
-2, -2, -3, -4, -2,  0, -3, -4, -3,  1,  2, -2,  7,
-3, -4, -4, -5, -3, -4, -5, -5, -2, -1,  0, -4, -1,  7,
-1, -3, -3, -3, -4, -2, -2, -3, -3, -4, -4, -2, -3, -4,  8,
 1, -1,  0, -1, -2, -1, -1, -1, -2, -3, -3, -1, -2, -3, -2,  5,
 0, -2,  0, -2, -2, -1, -1, -3, -2, -1, -2, -1, -1, -3, -2,  1,  6,
-4, -4, -5, -6, -4, -3, -5, -4, -3, -4, -3, -5, -2,  0, -5, -4, -4, 11,
-3, -3, -3, -4, -4, -3, -4, -5,  1, -2, -2, -3, -2,  3, -4, -3, -2,  2,  8,
-1, -3, -4, -5, -2, -3, -3, -5, -4,  3,  0, -3,  0, -2, -3, -2, -1, -3, -3,  5,
	};
	double tmpmtx100[] = 
	{
 8,
-3,10,
-4,-2,11,
-5,-5, 1,10,
-2,-8,-5,-8,14,
-2, 0,-1,-2,-7,11,
-3,-2,-2, 2,-9, 2,10,
-1,-6,-2,-4,-7,-5,-6, 9,
-4,-1, 0,-3,-8, 1,-2,-6,13,
-4,-7,-7,-8,-3,-6,-7,-9,-7, 8,
-4,-6,-7,-8,-5,-5,-7,-8,-6, 2, 8,
-2, 3,-1,-3,-8, 2, 0,-5,-3,-6,-6,10,
-3,-4,-5,-8,-4,-2,-5,-7,-5, 1, 3,-4,12,
-5,-6,-7,-8,-4,-6,-8,-8,-4,-2, 0,-6,-1,11,
-2,-5,-5,-5,-8,-4,-4,-6,-5,-7,-7,-3,-5,-7,12,
 1,-3, 0,-2,-3,-2,-2,-2,-3,-5,-6,-2,-4,-5,-3, 9,
-1,-3,-1,-4,-3,-3,-3,-5,-4,-3,-4,-3,-2,-5,-4, 2, 9,
-6,-7,-8,-10,-7,-5,-8,-7,-5,-6,-5,-8,-4, 0,-8,-7,-7,17,
-5,-5,-5,-7,-6,-4,-7,-8, 1,-4,-4,-5,-5, 4,-7,-5,-5, 2,12,
-2,-6,-7,-8,-3,-5,-5,-8,-7, 4, 0,-5, 0,-3,-6,-4,-1,-5,-5, 8,
	};
	double tmpmtx0[] = 
	{
     2.4,
    -0.6,    4.7,
    -0.3,    0.3,    3.8,
    -0.3,   -0.3,    2.2,    4.7,
     0.5,   -2.2,   -1.8,   -3.2,   11.5,
    -0.2,    1.5,    0.7,    0.9,   -2.4,    2.7,
     0.0,    0.4,    0.9,    2.7,   -3.0,    1.7,    3.6,
     0.5,   -1.0,    0.4,    0.1,   -2.0,   -1.0,   -0.8,    6.6,
    -0.8,    0.6,    1.2,    0.4,   -1.3,    1.2,    0.4,   -1.4,    6.0,
    -0.8,   -2.4,   -2.8,   -3.8,   -1.1,   -1.9,   -2.7,   -4.5,   -2.2,    4.0,
    -1.2,   -2.2,   -3.0,   -4.0,   -1.5,   -1.6,   -2.8,   -4.4,   -1.9,    2.8,    4.0,
    -0.4,    2.7,    0.8,    0.5,   -2.8,    1.5,    1.2,   -1.1,    0.6,   -2.1,   -2.1,    3.2,
    -0.7,   -1.7,   -2.2,   -3.0,   -0.9,   -1.0,   -2.0,   -3.5,   -1.3,    2.5,    2.8,   -1.4,    4.3,
    -2.3,   -3.2,   -3.1,   -4.5,   -0.8,   -2.6,   -3.9,   -5.2,   -0.1,    1.0,    2.0,   -3.3,    1.6,    7.0,
     0.3,   -0.9,   -0.9,   -0.7,   -3.1,   -0.2,   -0.5,   -1.6,   -1.1,   -2.6,   -2.3,   -0.6,   -2.4,   -3.8,    7.6,
     1.1,   -0.2,    0.9,    0.5,    0.1,    0.2,    0.2,    0.4,   -0.2,   -1.8,   -2.1,    0.1,   -1.4,   -2.8,    0.4,    2.2,
     0.6,   -0.2,    0.5,    0.0,   -0.5,    0.0,   -0.1,   -1.1,   -0.3,   -0.6,   -1.3,    0.1,   -0.6,   -2.2,    0.1,    1.5,    2.5,
    -3.6,   -1.6,   -3.6,   -5.2,   -1.0,   -2.7,   -4.3,   -4.0,   -0.8,   -1.8,   -0.7,   -3.5,   -1.0,    3.6,   -5.0,   -3.3,   -3.5,   14.2,
    -2.2,   -1.8,   -1.4,   -2.8,   -0.5,   -1.7,   -2.7,   -4.0,    2.2,   -0.7,    0.0,   -2.1,   -0.2,    5.1,   -3.1,   -1.9,   -1.9,    4.1,    7.8,
     0.1,   -2.0,   -2.2,   -2.9,    0.0,   -1.5,   -1.9,   -3.3,   -2.0,    3.1,    1.8,   -1.7,    1.6,    0.1,   -1.8,   -1.0,    0.0,   -2.6,   -1.1,    3.4,
	};

	int i, j, count;
	double av;
	double *tmpmtx;

	if( n == 30 ) tmpmtx = tmpmtx30;
	else if( n == 45 ) tmpmtx = tmpmtx45;
	else if( n == 50 ) tmpmtx = tmpmtx50;
	else if( n == 62 ) tmpmtx = tmpmtx62;
	else if( n == 80 ) tmpmtx = tmpmtx80;
	else if( n == 90 ) tmpmtx = tmpmtx90;
	else if( n == 100 ) tmpmtx = tmpmtx100;
	else if( n == 0 ) tmpmtx = tmpmtx0;
	else if( n == -1 ) tmpmtx = loadaamtx( rescalept );
	else
	{
		fprintf( stderr, "blosum %d ?\n", n );
		exit( 1 );
	}

	count = 0;
	for( i=0; i<20; i++ )
	{
		for( j=0; j<=i; j++ )
		{
			matrix[i][j] = matrix[j][i] = (double)tmpmtx[count++];
		}
	}
	if( n == -1 && tmpmtx[400] != -1.0 ) 
	{
		for( i=0; i<20; i++ ) freq[i] = tmpmtx[400+i];
		av = 0.0;
		for( i=0; i<20; i++ ) av += freq[i];
		for( i=0; i<20; i++ ) freq[i] /= av;
	}
	else
		for( i=0; i<20; i++ ) freq[i] = freqd[i];

	if( n == -1 ) free( tmpmtx );
#if 0
	av = 0.0;
	for( i=0; i<20; i++ )
		av += matrix[i][i];
	av /= 20;
	fprintf( stdout, "av = %f\n", av );

	for( i=0; i<20; i++ ) for( j=0; j<20; j++ )
		matrix[i][j] /= av;

	av = wav = 0;
	count = 0;
	wcount = 0.0;
	tmptmp = 0.0;
	for( i=0; i<20; i++ )
	{
		fprintf( stdout, "freq[%d] = %f\n", i, freq[i] );
		tmptmp += freq[i];
		for( j=0; j<20; j++ )
		{
			av += matrix[i][j];
			wav += freq[i] * freq[j] * matrix[i][j];
			count++;
			wcount += freq[i] * freq[j];
		}
	}

	av /= count;
	wav /= wcount;
	fprintf( stdout, "av = %f\n", av );
	fprintf( stdout, "wav = %f\n", wav );
	fprintf( stdout, "wcount = %f\n", wcount );
	fprintf( stdout, "tmptmp = %f\n", tmptmp );

	for( i=0; i<20; i++ )
	{
		for( j=0; j<=i; j++ )
		{
			fprintf( stderr, "## %d-%d, %f\n", i, j, matrix[i][j] );
		}
	}

	exit( 1 );
#endif

    for( i=0; i<26; i++ ) amino[i] = locaminod[i];
    for( i=0; i<26; i++ ) amino_grp[(int)amino[i]] = locgrpd[i];
}

static int checkchar( int i )
{
	if( i > 0xff || i <= 0x00 || i == 0x3E || i == 0x3D || i == 0x3C || i == 0x2D || i == 0x20 || i == 0x0d || i == 0x0a )
		return( 1 );
	return( 0 );
}

static int overridematrix( double **matrix )
{
	char buf[500];
	FILE *fp;
	unsigned int i1, i2;
	double v;
	char *bpt;
	int nread;
	int userdefined;

	fp = fopen( "_aamtx", "r" );
	if( fp == NULL )
	{
		fprintf( stderr, "warning: cannot open scorematrix. Use the default one.\n" );
//		f2cl.c de tomaranai youni
//		exit( 1 );
		return 0;
	}

	userdefined = 0;
	while( 1 )
	{
		fgets( buf, 499, fp );
		if( feof( fp ) ) break;

		if( ( bpt = strchr( buf, '#' ) ) ) *bpt = 0;

		i1 = i2 = 0;
		nread = sscanf( buf, "%x %x %lf", &i1, &i2, &v );
		if( nread == EOF ) continue;
		if( nread != 3 )
		{
			reporterr( "Format error in this line?\n" );
			reporterr( "%s\n", buf );
//			reporterr( "To set a score, 100, for a match of 0x41 and 0x42, \n" );
//			reporterr( "0x41 0x42 100 \n" );
			exit( 1 );
		}
		if( checkchar( i1 ) )
		{
			reporterr( "%c=0x%x cannot be used (1)\n", i1, i1 );
			exit( 1 );
		}
		if( checkchar( i2 ) )
		{
			reporterr( "%c=0x%x cannot be used (2)\n", i2, i2 );
			exit( 1 );
		}
//		reporterr( "Score(%c=0x%x,%c=0x%x)=%f\n", i1, i1, i2, i2, v );
		matrix[i1][i2] = v;
		matrix[i2][i1] = v; // 2018/May/11
		userdefined = 1;
	}
	fclose( fp );
	return userdefined;
}

int extendedmtx( double **matrix, double *freq, unsigned char *amino, char *amino_grp )
{
	int i;
	int j;
	int userdefined;

	for( i=0; i<nalphabets; i++ ) 
	{
//		fprintf( stderr, "i=%d, i=%c\n", i, i );
		amino[i] = (unsigned char)i;
	}
	for( i=0; i<nalphabets; i++ ) amino_grp[(int)amino[i]] = i % 6;
	for( i=0; i<nalphabets; i++ ) freq[i] = 1.0/nalphabets;

	for( i=0; i<nalphabets; i++ )
	{
		for( j=0; j<=i; j++ )
		{
			matrix[i][j] = matrix[j][i] = (double)-1.0;
		}
	}
	for( i=0; i<nalphabets; i++ )
		matrix[i][i] = matrix[i][i] = (double)1.0;

	userdefined = overridematrix( matrix );

#if 0 // user-defined matrix + user-defined freqency ga aru toki fukkatsu saseru.
	if( tmpmtx[400] != -1.0 ) 
	{
		for( i=0; i<20; i++ ) freq[i] = tmpmtx[400+i];
		av = 0.0;
		for( i=0; i<20; i++ ) av += freq[i];
		for( i=0; i<20; i++ ) freq[i] /= av;
	}
	else
		for( i=0; i<20; i++ ) freq[i] = freqd[i];
#endif
#if 0
	for( i=0; i<nalphabets; i++ )
	{
		fprintf( stderr, "%d: %c, %d, %f\n", i, amino[i], amino_grp[amino[i]], freq[i] );
	}
#endif
	return userdefined;
}
