;; Tests for int-to-int extension operations.

(module
  (func (export "i16x8.extend_high_i8x16_s") (param v128) (result v128) (i16x8.extend_high_i8x16_s (local.get 0)))
  (func (export "i16x8.extend_high_i8x16_u") (param v128) (result v128) (i16x8.extend_high_i8x16_u (local.get 0)))
  (func (export "i16x8.extend_low_i8x16_s") (param v128) (result v128) (i16x8.extend_low_i8x16_s (local.get 0)))
  (func (export "i16x8.extend_low_i8x16_u") (param v128) (result v128) (i16x8.extend_low_i8x16_u (local.get 0)))
  (func (export "i32x4.extend_high_i16x8_s") (param v128) (result v128) (i32x4.extend_high_i16x8_s (local.get 0)))
  (func (export "i32x4.extend_high_i16x8_u") (param v128) (result v128) (i32x4.extend_high_i16x8_u (local.get 0)))
  (func (export "i32x4.extend_low_i16x8_s") (param v128) (result v128) (i32x4.extend_low_i16x8_s (local.get 0)))
  (func (export "i32x4.extend_low_i16x8_u") (param v128) (result v128) (i32x4.extend_low_i16x8_u (local.get 0)))
  (func (export "i64x2.extend_high_i32x4_s") (param v128) (result v128) (i64x2.extend_high_i32x4_s (local.get 0)))
  (func (export "i64x2.extend_high_i32x4_u") (param v128) (result v128) (i64x2.extend_high_i32x4_u (local.get 0)))
  (func (export "i64x2.extend_low_i32x4_s") (param v128) (result v128) (i64x2.extend_low_i32x4_s (local.get 0)))
  (func (export "i64x2.extend_low_i32x4_u") (param v128) (result v128) (i64x2.extend_low_i32x4_u (local.get 0)))
)

(assert_return (invoke "i16x8.extend_high_i8x16_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.extend_high_i8x16_s" (v128.const i8x16 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1))
                                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.extend_high_i8x16_s" (v128.const i8x16 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.extend_high_i8x16_s" (v128.const i8x16 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0))
                                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.extend_high_i8x16_s" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 0 0 0 0 0 0 0 0))
                                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.extend_high_i8x16_s" (v128.const i8x16 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.extend_high_i8x16_s" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1))
                                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.extend_high_i8x16_s" (v128.const i8x16 126 126 126 126 126 126 126 126 127 127 127 127 127 127 127 127))
                                                   (v128.const i16x8 127 127 127 127 127 127 127 127))
(assert_return (invoke "i16x8.extend_high_i8x16_s" (v128.const i8x16 127 127 127 127 127 127 127 127 126 126 126 126 126 126 126 126))
                                                   (v128.const i16x8 126 126 126 126 126 126 126 126))
(assert_return (invoke "i16x8.extend_high_i8x16_s" (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
                                                   (v128.const i16x8 127 127 127 127 127 127 127 127))
(assert_return (invoke "i16x8.extend_high_i8x16_s" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                                   (v128.const i16x8 -128 -128 -128 -128 -128 -128 -128 -128))
(assert_return (invoke "i16x8.extend_high_i8x16_s" (v128.const i8x16 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128))
                                                   (v128.const i16x8 -128 -128 -128 -128 -128 -128 -128 -128))
(assert_return (invoke "i16x8.extend_high_i8x16_s" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127))
                                                   (v128.const i16x8 127 127 127 127 127 127 127 127))
(assert_return (invoke "i16x8.extend_high_i8x16_s" (v128.const i8x16 127 127 127 127 127 127 127 127 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.extend_high_i8x16_s" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 127 127 127 127 127 127 127 127))
                                                   (v128.const i16x8 127 127 127 127 127 127 127 127))
(assert_return (invoke "i16x8.extend_high_i8x16_s" (v128.const i8x16 -127 -127 -127 -127 -127 -127 -127 -127 -128 -128 -128 -128 -128 -128 -128 -128))
                                                   (v128.const i16x8 -128 -128 -128 -128 -128 -128 -128 -128))
(assert_return (invoke "i16x8.extend_high_i8x16_s" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -127 -127 -127 -127 -127 -127 -127 -127))
                                                   (v128.const i16x8 -127 -127 -127 -127 -127 -127 -127 -127))
(assert_return (invoke "i16x8.extend_high_i8x16_s" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.extend_high_i8x16_s" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -128 -128 -128 -128 -128 -128 -128 -128))
                                                   (v128.const i16x8 -128 -128 -128 -128 -128 -128 -128 -128))

(assert_return (invoke "i16x8.extend_high_i8x16_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.extend_high_i8x16_u" (v128.const i8x16 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1))
                                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.extend_high_i8x16_u" (v128.const i8x16 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i16x8 255 255 255 255 255 255 255 255))
(assert_return (invoke "i16x8.extend_high_i8x16_u" (v128.const i8x16 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0))
                                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.extend_high_i8x16_u" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 0 0 0 0 0 0 0 0))
                                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.extend_high_i8x16_u" (v128.const i8x16 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i16x8 255 255 255 255 255 255 255 255))
(assert_return (invoke "i16x8.extend_high_i8x16_u" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1))
                                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.extend_high_i8x16_u" (v128.const i8x16 126 126 126 126 126 126 126 126 127 127 127 127 127 127 127 127))
                                                   (v128.const i16x8 127 127 127 127 127 127 127 127))
(assert_return (invoke "i16x8.extend_high_i8x16_u" (v128.const i8x16 127 127 127 127 127 127 127 127 126 126 126 126 126 126 126 126))
                                                   (v128.const i16x8 126 126 126 126 126 126 126 126))
(assert_return (invoke "i16x8.extend_high_i8x16_u" (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
                                                   (v128.const i16x8 127 127 127 127 127 127 127 127))
(assert_return (invoke "i16x8.extend_high_i8x16_u" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                                   (v128.const i16x8 128 128 128 128 128 128 128 128))
(assert_return (invoke "i16x8.extend_high_i8x16_u" (v128.const i8x16 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128))
                                                   (v128.const i16x8 128 128 128 128 128 128 128 128))
(assert_return (invoke "i16x8.extend_high_i8x16_u" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127))
                                                   (v128.const i16x8 127 127 127 127 127 127 127 127))
(assert_return (invoke "i16x8.extend_high_i8x16_u" (v128.const i8x16 127 127 127 127 127 127 127 127 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i16x8 255 255 255 255 255 255 255 255))
(assert_return (invoke "i16x8.extend_high_i8x16_u" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 127 127 127 127 127 127 127 127))
                                                   (v128.const i16x8 127 127 127 127 127 127 127 127))
(assert_return (invoke "i16x8.extend_high_i8x16_u" (v128.const i8x16 -127 -127 -127 -127 -127 -127 -127 -127 -128 -128 -128 -128 -128 -128 -128 -128))
                                                   (v128.const i16x8 128 128 128 128 128 128 128 128))
(assert_return (invoke "i16x8.extend_high_i8x16_u" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -127 -127 -127 -127 -127 -127 -127 -127))
                                                   (v128.const i16x8 129 129 129 129 129 129 129 129))
(assert_return (invoke "i16x8.extend_high_i8x16_u" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -1 -1 -1 -1 -1 -1 -1 -1))
                                                   (v128.const i16x8 255 255 255 255 255 255 255 255))
(assert_return (invoke "i16x8.extend_high_i8x16_u" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -128 -128 -128 -128 -128 -128 -128 -128))
                                                   (v128.const i16x8 128 128 128 128 128 128 128 128))

(assert_return (invoke "i16x8.extend_low_i8x16_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                  (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.extend_low_i8x16_s" (v128.const i8x16 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1))
                                                  (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.extend_low_i8x16_s" (v128.const i8x16 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.extend_low_i8x16_s" (v128.const i8x16 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0))
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.extend_low_i8x16_s" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 0 0 0 0 0 0 0 0))
                                                  (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.extend_low_i8x16_s" (v128.const i8x16 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.extend_low_i8x16_s" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1))
                                                  (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.extend_low_i8x16_s" (v128.const i8x16 126 126 126 126 126 126 126 126 127 127 127 127 127 127 127 127))
                                                  (v128.const i16x8 126 126 126 126 126 126 126 126))
(assert_return (invoke "i16x8.extend_low_i8x16_s" (v128.const i8x16 127 127 127 127 127 127 127 127 126 126 126 126 126 126 126 126))
                                                  (v128.const i16x8 127 127 127 127 127 127 127 127))
(assert_return (invoke "i16x8.extend_low_i8x16_s" (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
                                                  (v128.const i16x8 127 127 127 127 127 127 127 127))
(assert_return (invoke "i16x8.extend_low_i8x16_s" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                                  (v128.const i16x8 -128 -128 -128 -128 -128 -128 -128 -128))
(assert_return (invoke "i16x8.extend_low_i8x16_s" (v128.const i8x16 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128))
                                                  (v128.const i16x8 127 127 127 127 127 127 127 127))
(assert_return (invoke "i16x8.extend_low_i8x16_s" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127))
                                                  (v128.const i16x8 -128 -128 -128 -128 -128 -128 -128 -128))
(assert_return (invoke "i16x8.extend_low_i8x16_s" (v128.const i8x16 127 127 127 127 127 127 127 127 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i16x8 127 127 127 127 127 127 127 127))
(assert_return (invoke "i16x8.extend_low_i8x16_s" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 127 127 127 127 127 127 127 127))
                                                  (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.extend_low_i8x16_s" (v128.const i8x16 -127 -127 -127 -127 -127 -127 -127 -127 -128 -128 -128 -128 -128 -128 -128 -128))
                                                  (v128.const i16x8 -127 -127 -127 -127 -127 -127 -127 -127))
(assert_return (invoke "i16x8.extend_low_i8x16_s" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -127 -127 -127 -127 -127 -127 -127 -127))
                                                  (v128.const i16x8 -128 -128 -128 -128 -128 -128 -128 -128))
(assert_return (invoke "i16x8.extend_low_i8x16_s" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i16x8 -128 -128 -128 -128 -128 -128 -128 -128))
(assert_return (invoke "i16x8.extend_low_i8x16_s" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -128 -128 -128 -128 -128 -128 -128 -128))
                                                  (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))

(assert_return (invoke "i16x8.extend_low_i8x16_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                  (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.extend_low_i8x16_u" (v128.const i8x16 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1))
                                                  (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.extend_low_i8x16_u" (v128.const i8x16 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.extend_low_i8x16_u" (v128.const i8x16 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0))
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.extend_low_i8x16_u" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 0 0 0 0 0 0 0 0))
                                                  (v128.const i16x8 255 255 255 255 255 255 255 255))
(assert_return (invoke "i16x8.extend_low_i8x16_u" (v128.const i8x16 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.extend_low_i8x16_u" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1))
                                                  (v128.const i16x8 255 255 255 255 255 255 255 255))
(assert_return (invoke "i16x8.extend_low_i8x16_u" (v128.const i8x16 126 126 126 126 126 126 126 126 127 127 127 127 127 127 127 127))
                                                  (v128.const i16x8 126 126 126 126 126 126 126 126))
(assert_return (invoke "i16x8.extend_low_i8x16_u" (v128.const i8x16 127 127 127 127 127 127 127 127 126 126 126 126 126 126 126 126))
                                                  (v128.const i16x8 127 127 127 127 127 127 127 127))
(assert_return (invoke "i16x8.extend_low_i8x16_u" (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
                                                  (v128.const i16x8 127 127 127 127 127 127 127 127))
(assert_return (invoke "i16x8.extend_low_i8x16_u" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                                  (v128.const i16x8 128 128 128 128 128 128 128 128))
(assert_return (invoke "i16x8.extend_low_i8x16_u" (v128.const i8x16 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128))
                                                  (v128.const i16x8 127 127 127 127 127 127 127 127))
(assert_return (invoke "i16x8.extend_low_i8x16_u" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127))
                                                  (v128.const i16x8 128 128 128 128 128 128 128 128))
(assert_return (invoke "i16x8.extend_low_i8x16_u" (v128.const i8x16 127 127 127 127 127 127 127 127 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i16x8 127 127 127 127 127 127 127 127))
(assert_return (invoke "i16x8.extend_low_i8x16_u" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 127 127 127 127 127 127 127 127))
                                                  (v128.const i16x8 255 255 255 255 255 255 255 255))
(assert_return (invoke "i16x8.extend_low_i8x16_u" (v128.const i8x16 -127 -127 -127 -127 -127 -127 -127 -127 -128 -128 -128 -128 -128 -128 -128 -128))
                                                  (v128.const i16x8 129 129 129 129 129 129 129 129))
(assert_return (invoke "i16x8.extend_low_i8x16_u" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -127 -127 -127 -127 -127 -127 -127 -127))
                                                  (v128.const i16x8 128 128 128 128 128 128 128 128))
(assert_return (invoke "i16x8.extend_low_i8x16_u" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -1 -1 -1 -1 -1 -1 -1 -1))
                                                  (v128.const i16x8 128 128 128 128 128 128 128 128))
(assert_return (invoke "i16x8.extend_low_i8x16_u" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -128 -128 -128 -128 -128 -128 -128 -128))
                                                  (v128.const i16x8 255 255 255 255 255 255 255 255))

(assert_return (invoke "i32x4.extend_high_i16x8_s" (v128.const i16x8 0 0 0 0 0 0 0 0))
                                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.extend_high_i16x8_s" (v128.const i16x8 0 0 0 0 1 1 1 1))
                                                   (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.extend_high_i16x8_s" (v128.const i16x8 0 0 0 0 -1 -1 -1 -1))
                                                   (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "i32x4.extend_high_i16x8_s" (v128.const i16x8 1 1 1 1 0 0 0 0))
                                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.extend_high_i16x8_s" (v128.const i16x8 -1 -1 -1 -1 0 0 0 0))
                                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.extend_high_i16x8_s" (v128.const i16x8 1 1 1 1 -1 -1 -1 -1))
                                                   (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "i32x4.extend_high_i16x8_s" (v128.const i16x8 -1 -1 -1 -1 1 1 1 1))
                                                   (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.extend_high_i16x8_s" (v128.const i16x8 32766 32766 32766 32766 32767 32767 32767 32767))
                                                   (v128.const i32x4 32767 32767 32767 32767))
(assert_return (invoke "i32x4.extend_high_i16x8_s" (v128.const i16x8 32767 32767 32767 32767 32766 32766 32766 32766))
                                                   (v128.const i32x4 32766 32766 32766 32766))
(assert_return (invoke "i32x4.extend_high_i16x8_s" (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                                   (v128.const i32x4 32767 32767 32767 32767))
(assert_return (invoke "i32x4.extend_high_i16x8_s" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                                   (v128.const i32x4 -32768 -32768 -32768 -32768))
(assert_return (invoke "i32x4.extend_high_i16x8_s" (v128.const i16x8 32767 32767 32767 32767 -32768 -32768 -32768 -32768))
                                                   (v128.const i32x4 -32768 -32768 -32768 -32768))
(assert_return (invoke "i32x4.extend_high_i16x8_s" (v128.const i16x8 -32768 -32768 -32768 -32768 32767 32767 32767 32767))
                                                   (v128.const i32x4 32767 32767 32767 32767))
(assert_return (invoke "i32x4.extend_high_i16x8_s" (v128.const i16x8 32767 32767 32767 32767 -1 -1 -1 -1))
                                                   (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "i32x4.extend_high_i16x8_s" (v128.const i16x8 -1 -1 -1 -1 32767 32767 32767 32767))
                                                   (v128.const i32x4 32767 32767 32767 32767))
(assert_return (invoke "i32x4.extend_high_i16x8_s" (v128.const i16x8 -32767 -32767 -32767 -32767 -32768 -32768 -32768 -32768))
                                                   (v128.const i32x4 -32768 -32768 -32768 -32768))
(assert_return (invoke "i32x4.extend_high_i16x8_s" (v128.const i16x8 -32768 -32768 -32768 -32768 -32767 -32767 -32767 -32767))
                                                   (v128.const i32x4 -32767 -32767 -32767 -32767))
(assert_return (invoke "i32x4.extend_high_i16x8_s" (v128.const i16x8 -32768 -32768 -32768 -32768 -1 -1 -1 -1))
                                                   (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "i32x4.extend_high_i16x8_s" (v128.const i16x8 -1 -1 -1 -1 -32768 -32768 -32768 -32768))
                                                   (v128.const i32x4 -32768 -32768 -32768 -32768))

(assert_return (invoke "i32x4.extend_high_i16x8_u" (v128.const i16x8 0 0 0 0 0 0 0 0))
                                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.extend_high_i16x8_u" (v128.const i16x8 0 0 0 0 1 1 1 1))
                                                   (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.extend_high_i16x8_u" (v128.const i16x8 0 0 0 0 -1 -1 -1 -1))
                                                   (v128.const i32x4 65535 65535 65535 65535))
(assert_return (invoke "i32x4.extend_high_i16x8_u" (v128.const i16x8 1 1 1 1 0 0 0 0))
                                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.extend_high_i16x8_u" (v128.const i16x8 -1 -1 -1 -1 0 0 0 0))
                                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.extend_high_i16x8_u" (v128.const i16x8 1 1 1 1 -1 -1 -1 -1))
                                                   (v128.const i32x4 65535 65535 65535 65535))
(assert_return (invoke "i32x4.extend_high_i16x8_u" (v128.const i16x8 -1 -1 -1 -1 1 1 1 1))
                                                   (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.extend_high_i16x8_u" (v128.const i16x8 32766 32766 32766 32766 32767 32767 32767 32767))
                                                   (v128.const i32x4 32767 32767 32767 32767))
(assert_return (invoke "i32x4.extend_high_i16x8_u" (v128.const i16x8 32767 32767 32767 32767 32766 32766 32766 32766))
                                                   (v128.const i32x4 32766 32766 32766 32766))
(assert_return (invoke "i32x4.extend_high_i16x8_u" (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                                   (v128.const i32x4 32767 32767 32767 32767))
(assert_return (invoke "i32x4.extend_high_i16x8_u" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                                   (v128.const i32x4 32768 32768 32768 32768))
(assert_return (invoke "i32x4.extend_high_i16x8_u" (v128.const i16x8 32767 32767 32767 32767 -32768 -32768 -32768 -32768))
                                                   (v128.const i32x4 32768 32768 32768 32768))
(assert_return (invoke "i32x4.extend_high_i16x8_u" (v128.const i16x8 -32768 -32768 -32768 -32768 32767 32767 32767 32767))
                                                   (v128.const i32x4 32767 32767 32767 32767))
(assert_return (invoke "i32x4.extend_high_i16x8_u" (v128.const i16x8 32767 32767 32767 32767 -1 -1 -1 -1))
                                                   (v128.const i32x4 65535 65535 65535 65535))
(assert_return (invoke "i32x4.extend_high_i16x8_u" (v128.const i16x8 -1 -1 -1 -1 32767 32767 32767 32767))
                                                   (v128.const i32x4 32767 32767 32767 32767))
(assert_return (invoke "i32x4.extend_high_i16x8_u" (v128.const i16x8 -32767 -32767 -32767 -32767 -32768 -32768 -32768 -32768))
                                                   (v128.const i32x4 32768 32768 32768 32768))
(assert_return (invoke "i32x4.extend_high_i16x8_u" (v128.const i16x8 -32768 -32768 -32768 -32768 -32767 -32767 -32767 -32767))
                                                   (v128.const i32x4 32769 32769 32769 32769))
(assert_return (invoke "i32x4.extend_high_i16x8_u" (v128.const i16x8 -32768 -32768 -32768 -32768 -1 -1 -1 -1))
                                                   (v128.const i32x4 65535 65535 65535 65535))
(assert_return (invoke "i32x4.extend_high_i16x8_u" (v128.const i16x8 -1 -1 -1 -1 -32768 -32768 -32768 -32768))
                                                   (v128.const i32x4 32768 32768 32768 32768))

(assert_return (invoke "i32x4.extend_low_i16x8_s" (v128.const i16x8 0 0 0 0 0 0 0 0))
                                                  (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.extend_low_i16x8_s" (v128.const i16x8 0 0 0 0 1 1 1 1))
                                                  (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.extend_low_i16x8_s" (v128.const i16x8 0 0 0 0 -1 -1 -1 -1))
                                                  (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.extend_low_i16x8_s" (v128.const i16x8 1 1 1 1 0 0 0 0))
                                                  (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.extend_low_i16x8_s" (v128.const i16x8 -1 -1 -1 -1 0 0 0 0))
                                                  (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "i32x4.extend_low_i16x8_s" (v128.const i16x8 1 1 1 1 -1 -1 -1 -1))
                                                  (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.extend_low_i16x8_s" (v128.const i16x8 -1 -1 -1 -1 1 1 1 1))
                                                  (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "i32x4.extend_low_i16x8_s" (v128.const i16x8 32766 32766 32766 32766 32767 32767 32767 32767))
                                                  (v128.const i32x4 32766 32766 32766 32766))
(assert_return (invoke "i32x4.extend_low_i16x8_s" (v128.const i16x8 32767 32767 32767 32767 32766 32766 32766 32766))
                                                  (v128.const i32x4 32767 32767 32767 32767))
(assert_return (invoke "i32x4.extend_low_i16x8_s" (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                                  (v128.const i32x4 32767 32767 32767 32767))
(assert_return (invoke "i32x4.extend_low_i16x8_s" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                                  (v128.const i32x4 -32768 -32768 -32768 -32768))
(assert_return (invoke "i32x4.extend_low_i16x8_s" (v128.const i16x8 32767 32767 32767 32767 -32768 -32768 -32768 -32768))
                                                  (v128.const i32x4 32767 32767 32767 32767))
(assert_return (invoke "i32x4.extend_low_i16x8_s" (v128.const i16x8 -32768 -32768 -32768 -32768 32767 32767 32767 32767))
                                                  (v128.const i32x4 -32768 -32768 -32768 -32768))
(assert_return (invoke "i32x4.extend_low_i16x8_s" (v128.const i16x8 32767 32767 32767 32767 -1 -1 -1 -1))
                                                  (v128.const i32x4 32767 32767 32767 32767))
(assert_return (invoke "i32x4.extend_low_i16x8_s" (v128.const i16x8 -1 -1 -1 -1 32767 32767 32767 32767))
                                                  (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "i32x4.extend_low_i16x8_s" (v128.const i16x8 -32767 -32767 -32767 -32767 -32768 -32768 -32768 -32768))
                                                  (v128.const i32x4 -32767 -32767 -32767 -32767))
(assert_return (invoke "i32x4.extend_low_i16x8_s" (v128.const i16x8 -32768 -32768 -32768 -32768 -32767 -32767 -32767 -32767))
                                                  (v128.const i32x4 -32768 -32768 -32768 -32768))
(assert_return (invoke "i32x4.extend_low_i16x8_s" (v128.const i16x8 -32768 -32768 -32768 -32768 -1 -1 -1 -1))
                                                  (v128.const i32x4 -32768 -32768 -32768 -32768))
(assert_return (invoke "i32x4.extend_low_i16x8_s" (v128.const i16x8 -1 -1 -1 -1 -32768 -32768 -32768 -32768))
                                                  (v128.const i32x4 -1 -1 -1 -1))

(assert_return (invoke "i32x4.extend_low_i16x8_u" (v128.const i16x8 0 0 0 0 0 0 0 0))
                                                  (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.extend_low_i16x8_u" (v128.const i16x8 0 0 0 0 1 1 1 1))
                                                  (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.extend_low_i16x8_u" (v128.const i16x8 0 0 0 0 -1 -1 -1 -1))
                                                  (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.extend_low_i16x8_u" (v128.const i16x8 1 1 1 1 0 0 0 0))
                                                  (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.extend_low_i16x8_u" (v128.const i16x8 -1 -1 -1 -1 0 0 0 0))
                                                  (v128.const i32x4 65535 65535 65535 65535))
(assert_return (invoke "i32x4.extend_low_i16x8_u" (v128.const i16x8 1 1 1 1 -1 -1 -1 -1))
                                                  (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.extend_low_i16x8_u" (v128.const i16x8 -1 -1 -1 -1 1 1 1 1))
                                                  (v128.const i32x4 65535 65535 65535 65535))
(assert_return (invoke "i32x4.extend_low_i16x8_u" (v128.const i16x8 32766 32766 32766 32766 32767 32767 32767 32767))
                                                  (v128.const i32x4 32766 32766 32766 32766))
(assert_return (invoke "i32x4.extend_low_i16x8_u" (v128.const i16x8 32767 32767 32767 32767 32766 32766 32766 32766))
                                                  (v128.const i32x4 32767 32767 32767 32767))
(assert_return (invoke "i32x4.extend_low_i16x8_u" (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                                  (v128.const i32x4 32767 32767 32767 32767))
(assert_return (invoke "i32x4.extend_low_i16x8_u" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                                  (v128.const i32x4 32768 32768 32768 32768))
(assert_return (invoke "i32x4.extend_low_i16x8_u" (v128.const i16x8 32767 32767 32767 32767 -32768 -32768 -32768 -32768))
                                                  (v128.const i32x4 32767 32767 32767 32767))
(assert_return (invoke "i32x4.extend_low_i16x8_u" (v128.const i16x8 -32768 -32768 -32768 -32768 32767 32767 32767 32767))
                                                  (v128.const i32x4 32768 32768 32768 32768))
(assert_return (invoke "i32x4.extend_low_i16x8_u" (v128.const i16x8 32767 32767 32767 32767 -1 -1 -1 -1))
                                                  (v128.const i32x4 32767 32767 32767 32767))
(assert_return (invoke "i32x4.extend_low_i16x8_u" (v128.const i16x8 -1 -1 -1 -1 32767 32767 32767 32767))
                                                  (v128.const i32x4 65535 65535 65535 65535))
(assert_return (invoke "i32x4.extend_low_i16x8_u" (v128.const i16x8 -32767 -32767 -32767 -32767 -32768 -32768 -32768 -32768))
                                                  (v128.const i32x4 32769 32769 32769 32769))
(assert_return (invoke "i32x4.extend_low_i16x8_u" (v128.const i16x8 -32768 -32768 -32768 -32768 -32767 -32767 -32767 -32767))
                                                  (v128.const i32x4 32768 32768 32768 32768))
(assert_return (invoke "i32x4.extend_low_i16x8_u" (v128.const i16x8 -32768 -32768 -32768 -32768 -1 -1 -1 -1))
                                                  (v128.const i32x4 32768 32768 32768 32768))
(assert_return (invoke "i32x4.extend_low_i16x8_u" (v128.const i16x8 -1 -1 -1 -1 -32768 -32768 -32768 -32768))
                                                  (v128.const i32x4 65535 65535 65535 65535))

(assert_return (invoke "i64x2.extend_high_i32x4_s" (v128.const i32x4 0 0 0 0))
                                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.extend_high_i32x4_s" (v128.const i32x4 0 0 1 1))
                                                   (v128.const i64x2 1 1))
(assert_return (invoke "i64x2.extend_high_i32x4_s" (v128.const i32x4 0 0 -1 -1))
                                                   (v128.const i64x2 -1 -1))
(assert_return (invoke "i64x2.extend_high_i32x4_s" (v128.const i32x4 1 1 0 0))
                                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.extend_high_i32x4_s" (v128.const i32x4 -1 -1 0 0))
                                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.extend_high_i32x4_s" (v128.const i32x4 1 1 -1 -1))
                                                   (v128.const i64x2 -1 -1))
(assert_return (invoke "i64x2.extend_high_i32x4_s" (v128.const i32x4 -1 -1 1 1))
                                                   (v128.const i64x2 1 1))
(assert_return (invoke "i64x2.extend_high_i32x4_s" (v128.const i32x4 2147483646 2147483646 2147483647 2147483647))
                                                   (v128.const i64x2 2147483647 2147483647))
(assert_return (invoke "i64x2.extend_high_i32x4_s" (v128.const i32x4 2147483647 2147483647 2147483646 2147483646))
                                                   (v128.const i64x2 2147483646 2147483646))
(assert_return (invoke "i64x2.extend_high_i32x4_s" (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
                                                   (v128.const i64x2 2147483647 2147483647))
(assert_return (invoke "i64x2.extend_high_i32x4_s" (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
                                                   (v128.const i64x2 -2147483648 -2147483648))
(assert_return (invoke "i64x2.extend_high_i32x4_s" (v128.const i32x4 2147483647 2147483647 -2147483648 -2147483648))
                                                   (v128.const i64x2 -2147483648 -2147483648))
(assert_return (invoke "i64x2.extend_high_i32x4_s" (v128.const i32x4 -2147483648 -2147483648 2147483647 2147483647))
                                                   (v128.const i64x2 2147483647 2147483647))
(assert_return (invoke "i64x2.extend_high_i32x4_s" (v128.const i32x4 2147483647 2147483647 -1 -1))
                                                   (v128.const i64x2 -1 -1))
(assert_return (invoke "i64x2.extend_high_i32x4_s" (v128.const i32x4 -1 -1 2147483647 2147483647))
                                                   (v128.const i64x2 2147483647 2147483647))
(assert_return (invoke "i64x2.extend_high_i32x4_s" (v128.const i32x4 -2147483647 -2147483647 -2147483648 -2147483648))
                                                   (v128.const i64x2 -2147483648 -2147483648))
(assert_return (invoke "i64x2.extend_high_i32x4_s" (v128.const i32x4 -2147483648 -2147483648 -2147483647 -2147483647))
                                                   (v128.const i64x2 -2147483647 -2147483647))
(assert_return (invoke "i64x2.extend_high_i32x4_s" (v128.const i32x4 -2147483648 -2147483648 -1 -1))
                                                   (v128.const i64x2 -1 -1))
(assert_return (invoke "i64x2.extend_high_i32x4_s" (v128.const i32x4 -1 -1 -2147483648 -2147483648))
                                                   (v128.const i64x2 -2147483648 -2147483648))

(assert_return (invoke "i64x2.extend_high_i32x4_u" (v128.const i32x4 0 0 0 0))
                                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.extend_high_i32x4_u" (v128.const i32x4 0 0 1 1))
                                                   (v128.const i64x2 1 1))
(assert_return (invoke "i64x2.extend_high_i32x4_u" (v128.const i32x4 0 0 -1 -1))
                                                   (v128.const i64x2 4294967295 4294967295))
(assert_return (invoke "i64x2.extend_high_i32x4_u" (v128.const i32x4 1 1 0 0))
                                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.extend_high_i32x4_u" (v128.const i32x4 -1 -1 0 0))
                                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.extend_high_i32x4_u" (v128.const i32x4 1 1 -1 -1))
                                                   (v128.const i64x2 4294967295 4294967295))
(assert_return (invoke "i64x2.extend_high_i32x4_u" (v128.const i32x4 -1 -1 1 1))
                                                   (v128.const i64x2 1 1))
(assert_return (invoke "i64x2.extend_high_i32x4_u" (v128.const i32x4 2147483646 2147483646 2147483647 2147483647))
                                                   (v128.const i64x2 2147483647 2147483647))
(assert_return (invoke "i64x2.extend_high_i32x4_u" (v128.const i32x4 2147483647 2147483647 2147483646 2147483646))
                                                   (v128.const i64x2 2147483646 2147483646))
(assert_return (invoke "i64x2.extend_high_i32x4_u" (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
                                                   (v128.const i64x2 2147483647 2147483647))
(assert_return (invoke "i64x2.extend_high_i32x4_u" (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
                                                   (v128.const i64x2 2147483648 2147483648))
(assert_return (invoke "i64x2.extend_high_i32x4_u" (v128.const i32x4 2147483647 2147483647 -2147483648 -2147483648))
                                                   (v128.const i64x2 2147483648 2147483648))
(assert_return (invoke "i64x2.extend_high_i32x4_u" (v128.const i32x4 -2147483648 -2147483648 2147483647 2147483647))
                                                   (v128.const i64x2 2147483647 2147483647))
(assert_return (invoke "i64x2.extend_high_i32x4_u" (v128.const i32x4 2147483647 2147483647 -1 -1))
                                                   (v128.const i64x2 4294967295 4294967295))
(assert_return (invoke "i64x2.extend_high_i32x4_u" (v128.const i32x4 -1 -1 2147483647 2147483647))
                                                   (v128.const i64x2 2147483647 2147483647))
(assert_return (invoke "i64x2.extend_high_i32x4_u" (v128.const i32x4 -2147483647 -2147483647 -2147483648 -2147483648))
                                                   (v128.const i64x2 2147483648 2147483648))
(assert_return (invoke "i64x2.extend_high_i32x4_u" (v128.const i32x4 -2147483648 -2147483648 -2147483647 -2147483647))
                                                   (v128.const i64x2 2147483649 2147483649))
(assert_return (invoke "i64x2.extend_high_i32x4_u" (v128.const i32x4 -2147483648 -2147483648 -1 -1))
                                                   (v128.const i64x2 4294967295 4294967295))
(assert_return (invoke "i64x2.extend_high_i32x4_u" (v128.const i32x4 -1 -1 -2147483648 -2147483648))
                                                   (v128.const i64x2 2147483648 2147483648))

(assert_return (invoke "i64x2.extend_low_i32x4_s" (v128.const i32x4 0 0 0 0))
                                                  (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.extend_low_i32x4_s" (v128.const i32x4 0 0 1 1))
                                                  (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.extend_low_i32x4_s" (v128.const i32x4 0 0 -1 -1))
                                                  (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.extend_low_i32x4_s" (v128.const i32x4 1 1 0 0))
                                                  (v128.const i64x2 1 1))
(assert_return (invoke "i64x2.extend_low_i32x4_s" (v128.const i32x4 -1 -1 0 0))
                                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "i64x2.extend_low_i32x4_s" (v128.const i32x4 1 1 -1 -1))
                                                  (v128.const i64x2 1 1))
(assert_return (invoke "i64x2.extend_low_i32x4_s" (v128.const i32x4 -1 -1 1 1))
                                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "i64x2.extend_low_i32x4_s" (v128.const i32x4 2147483646 2147483646 2147483647 2147483647))
                                                  (v128.const i64x2 2147483646 2147483646))
(assert_return (invoke "i64x2.extend_low_i32x4_s" (v128.const i32x4 2147483647 2147483647 2147483646 2147483646))
                                                  (v128.const i64x2 2147483647 2147483647))
(assert_return (invoke "i64x2.extend_low_i32x4_s" (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
                                                  (v128.const i64x2 2147483647 2147483647))
(assert_return (invoke "i64x2.extend_low_i32x4_s" (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
                                                  (v128.const i64x2 -2147483648 -2147483648))
(assert_return (invoke "i64x2.extend_low_i32x4_s" (v128.const i32x4 2147483647 2147483647 -2147483648 -2147483648))
                                                  (v128.const i64x2 2147483647 2147483647))
(assert_return (invoke "i64x2.extend_low_i32x4_s" (v128.const i32x4 -2147483648 -2147483648 2147483647 2147483647))
                                                  (v128.const i64x2 -2147483648 -2147483648))
(assert_return (invoke "i64x2.extend_low_i32x4_s" (v128.const i32x4 2147483647 2147483647 -1 -1))
                                                  (v128.const i64x2 2147483647 2147483647))
(assert_return (invoke "i64x2.extend_low_i32x4_s" (v128.const i32x4 -1 -1 2147483647 2147483647))
                                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "i64x2.extend_low_i32x4_s" (v128.const i32x4 -2147483647 -2147483647 -2147483648 -2147483648))
                                                  (v128.const i64x2 -2147483647 -2147483647))
(assert_return (invoke "i64x2.extend_low_i32x4_s" (v128.const i32x4 -2147483648 -2147483648 -2147483647 -2147483647))
                                                  (v128.const i64x2 -2147483648 -2147483648))
(assert_return (invoke "i64x2.extend_low_i32x4_s" (v128.const i32x4 -2147483648 -2147483648 -1 -1))
                                                  (v128.const i64x2 -2147483648 -2147483648))
(assert_return (invoke "i64x2.extend_low_i32x4_s" (v128.const i32x4 -1 -1 -2147483648 -2147483648))
                                                  (v128.const i64x2 -1 -1))

(assert_return (invoke "i64x2.extend_low_i32x4_u" (v128.const i32x4 0 0 0 0))
                                                  (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.extend_low_i32x4_u" (v128.const i32x4 0 0 1 1))
                                                  (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.extend_low_i32x4_u" (v128.const i32x4 0 0 -1 -1))
                                                  (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.extend_low_i32x4_u" (v128.const i32x4 1 1 0 0))
                                                  (v128.const i64x2 1 1))
(assert_return (invoke "i64x2.extend_low_i32x4_u" (v128.const i32x4 -1 -1 0 0))
                                                  (v128.const i64x2 4294967295 4294967295))
(assert_return (invoke "i64x2.extend_low_i32x4_u" (v128.const i32x4 1 1 -1 -1))
                                                  (v128.const i64x2 1 1))
(assert_return (invoke "i64x2.extend_low_i32x4_u" (v128.const i32x4 -1 -1 1 1))
                                                  (v128.const i64x2 4294967295 4294967295))
(assert_return (invoke "i64x2.extend_low_i32x4_u" (v128.const i32x4 2147483646 2147483646 2147483647 2147483647))
                                                  (v128.const i64x2 2147483646 2147483646))
(assert_return (invoke "i64x2.extend_low_i32x4_u" (v128.const i32x4 2147483647 2147483647 2147483646 2147483646))
                                                  (v128.const i64x2 2147483647 2147483647))
(assert_return (invoke "i64x2.extend_low_i32x4_u" (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
                                                  (v128.const i64x2 2147483647 2147483647))
(assert_return (invoke "i64x2.extend_low_i32x4_u" (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
                                                  (v128.const i64x2 2147483648 2147483648))
(assert_return (invoke "i64x2.extend_low_i32x4_u" (v128.const i32x4 2147483647 2147483647 -2147483648 -2147483648))
                                                  (v128.const i64x2 2147483647 2147483647))
(assert_return (invoke "i64x2.extend_low_i32x4_u" (v128.const i32x4 -2147483648 -2147483648 2147483647 2147483647))
                                                  (v128.const i64x2 2147483648 2147483648))
(assert_return (invoke "i64x2.extend_low_i32x4_u" (v128.const i32x4 2147483647 2147483647 -1 -1))
                                                  (v128.const i64x2 2147483647 2147483647))
(assert_return (invoke "i64x2.extend_low_i32x4_u" (v128.const i32x4 -1 -1 2147483647 2147483647))
                                                  (v128.const i64x2 4294967295 4294967295))
(assert_return (invoke "i64x2.extend_low_i32x4_u" (v128.const i32x4 -2147483647 -2147483647 -2147483648 -2147483648))
                                                  (v128.const i64x2 2147483649 2147483649))
(assert_return (invoke "i64x2.extend_low_i32x4_u" (v128.const i32x4 -2147483648 -2147483648 -2147483647 -2147483647))
                                                  (v128.const i64x2 2147483648 2147483648))
(assert_return (invoke "i64x2.extend_low_i32x4_u" (v128.const i32x4 -2147483648 -2147483648 -1 -1))
                                                  (v128.const i64x2 2147483648 2147483648))
(assert_return (invoke "i64x2.extend_low_i32x4_u" (v128.const i32x4 -1 -1 -2147483648 -2147483648))
                                                  (v128.const i64x2 4294967295 4294967295))


;; type check
(assert_invalid (module (func (result v128) (i16x8.extend_high_i8x16_s (i32.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i16x8.extend_high_i8x16_u (i32.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i16x8.extend_low_i8x16_s (i32.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i16x8.extend_low_i8x16_u (i32.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i32x4.extend_high_i16x8_s (i32.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i32x4.extend_high_i16x8_u (i32.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i32x4.extend_low_i16x8_s (i32.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i32x4.extend_low_i16x8_u (i32.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i64x2.extend_high_i32x4_s (i32.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i64x2.extend_high_i32x4_u (i32.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i64x2.extend_low_i32x4_s (i32.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i64x2.extend_low_i32x4_u (i32.const 0)))) "type mismatch")

;; Test operation with empty argument

(assert_invalid
  (module
    (func $i16x8.extend_high_i8x16_s-arg-empty (result v128)
      (i16x8.extend_high_i8x16_s)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.extend_high_i8x16_u-arg-empty (result v128)
      (i16x8.extend_high_i8x16_u)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.extend_low_i8x16_s-arg-empty (result v128)
      (i16x8.extend_low_i8x16_s)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.extend_low_i8x16_u-arg-empty (result v128)
      (i16x8.extend_low_i8x16_u)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i32x4.extend_high_i16x8_s-arg-empty (result v128)
      (i32x4.extend_high_i16x8_s)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i32x4.extend_high_i16x8_u-arg-empty (result v128)
      (i32x4.extend_high_i16x8_u)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i32x4.extend_low_i16x8_s-arg-empty (result v128)
      (i32x4.extend_low_i16x8_s)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i32x4.extend_low_i16x8_u-arg-empty (result v128)
      (i32x4.extend_low_i16x8_u)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i64x2.extend_high_i32x4_s-arg-empty (result v128)
      (i64x2.extend_high_i32x4_s)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i64x2.extend_high_i32x4_u-arg-empty (result v128)
      (i64x2.extend_high_i32x4_u)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i64x2.extend_low_i32x4_s-arg-empty (result v128)
      (i64x2.extend_low_i32x4_s)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i64x2.extend_low_i32x4_u-arg-empty (result v128)
      (i64x2.extend_low_i32x4_u)
    )
  )
  "type mismatch"
)

