/*
 * CLOUD API
 *
 *  IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
)

// ApplicationLoadBalancerPut struct for ApplicationLoadBalancerPut
type ApplicationLoadBalancerPut struct {
	// The resource's unique identifier.
	Id *string `json:"id,omitempty"`
	// The type of object that has been created.
	Type *Type `json:"type,omitempty"`
	// The URL to the object representation (absolute path).
	Href       *string                            `json:"href,omitempty"`
	Properties *ApplicationLoadBalancerProperties `json:"properties"`
}

// NewApplicationLoadBalancerPut instantiates a new ApplicationLoadBalancerPut object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewApplicationLoadBalancerPut(properties ApplicationLoadBalancerProperties) *ApplicationLoadBalancerPut {
	this := ApplicationLoadBalancerPut{}

	this.Properties = &properties

	return &this
}

// NewApplicationLoadBalancerPutWithDefaults instantiates a new ApplicationLoadBalancerPut object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewApplicationLoadBalancerPutWithDefaults() *ApplicationLoadBalancerPut {
	this := ApplicationLoadBalancerPut{}
	return &this
}

// GetId returns the Id field value
// If the value is explicit nil, nil is returned
func (o *ApplicationLoadBalancerPut) GetId() *string {
	if o == nil {
		return nil
	}

	return o.Id

}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ApplicationLoadBalancerPut) GetIdOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Id, true
}

// SetId sets field value
func (o *ApplicationLoadBalancerPut) SetId(v string) {

	o.Id = &v

}

// HasId returns a boolean if a field has been set.
func (o *ApplicationLoadBalancerPut) HasId() bool {
	if o != nil && o.Id != nil {
		return true
	}

	return false
}

// GetType returns the Type field value
// If the value is explicit nil, nil is returned
func (o *ApplicationLoadBalancerPut) GetType() *Type {
	if o == nil {
		return nil
	}

	return o.Type

}

// GetTypeOk returns a tuple with the Type field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ApplicationLoadBalancerPut) GetTypeOk() (*Type, bool) {
	if o == nil {
		return nil, false
	}

	return o.Type, true
}

// SetType sets field value
func (o *ApplicationLoadBalancerPut) SetType(v Type) {

	o.Type = &v

}

// HasType returns a boolean if a field has been set.
func (o *ApplicationLoadBalancerPut) HasType() bool {
	if o != nil && o.Type != nil {
		return true
	}

	return false
}

// GetHref returns the Href field value
// If the value is explicit nil, nil is returned
func (o *ApplicationLoadBalancerPut) GetHref() *string {
	if o == nil {
		return nil
	}

	return o.Href

}

// GetHrefOk returns a tuple with the Href field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ApplicationLoadBalancerPut) GetHrefOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Href, true
}

// SetHref sets field value
func (o *ApplicationLoadBalancerPut) SetHref(v string) {

	o.Href = &v

}

// HasHref returns a boolean if a field has been set.
func (o *ApplicationLoadBalancerPut) HasHref() bool {
	if o != nil && o.Href != nil {
		return true
	}

	return false
}

// GetProperties returns the Properties field value
// If the value is explicit nil, nil is returned
func (o *ApplicationLoadBalancerPut) GetProperties() *ApplicationLoadBalancerProperties {
	if o == nil {
		return nil
	}

	return o.Properties

}

// GetPropertiesOk returns a tuple with the Properties field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ApplicationLoadBalancerPut) GetPropertiesOk() (*ApplicationLoadBalancerProperties, bool) {
	if o == nil {
		return nil, false
	}

	return o.Properties, true
}

// SetProperties sets field value
func (o *ApplicationLoadBalancerPut) SetProperties(v ApplicationLoadBalancerProperties) {

	o.Properties = &v

}

// HasProperties returns a boolean if a field has been set.
func (o *ApplicationLoadBalancerPut) HasProperties() bool {
	if o != nil && o.Properties != nil {
		return true
	}

	return false
}

func (o ApplicationLoadBalancerPut) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Id != nil {
		toSerialize["id"] = o.Id
	}

	if o.Type != nil {
		toSerialize["type"] = o.Type
	}

	if o.Href != nil {
		toSerialize["href"] = o.Href
	}

	if o.Properties != nil {
		toSerialize["properties"] = o.Properties
	}

	return json.Marshal(toSerialize)
}

type NullableApplicationLoadBalancerPut struct {
	value *ApplicationLoadBalancerPut
	isSet bool
}

func (v NullableApplicationLoadBalancerPut) Get() *ApplicationLoadBalancerPut {
	return v.value
}

func (v *NullableApplicationLoadBalancerPut) Set(val *ApplicationLoadBalancerPut) {
	v.value = val
	v.isSet = true
}

func (v NullableApplicationLoadBalancerPut) IsSet() bool {
	return v.isSet
}

func (v *NullableApplicationLoadBalancerPut) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableApplicationLoadBalancerPut(val *ApplicationLoadBalancerPut) *NullableApplicationLoadBalancerPut {
	return &NullableApplicationLoadBalancerPut{value: val, isSet: true}
}

func (v NullableApplicationLoadBalancerPut) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableApplicationLoadBalancerPut) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
