.\"
.\" cupsd-helper man page for CUPS.
.\"
.\" Copyright 2007-2014 by Apple Inc.
.\" Copyright 1997-2006 by Easy Software Products.
.\"
.\" These coded instructions, statements, and computer programs are the
.\" property of Apple Inc. and are protected by Federal copyright
.\" law.  Distribution and use rights are outlined in the file "LICENSE.txt"
.\" which should have been included with this file.  If this file is
.\" file is missing or damaged, see the license at "http://www.cups.org/".
.\"
.TH cupsd-helper 8 "CUPS" "15 April 2014" "Apple Inc."
.SH NAME
cupsd\-helper \- cupsd helper programs
.SH SYNOPSIS
.B cups\-deviced
.I request-id
.I limit
.I user-id
.I options
.br
.B cups\-driverd
.B cat
.I ppd-name
.br
.B cups\-driverd
.B list
.I request_id
.I limit
.I options
.br
.B cups\-exec
.I sandbox-profile
[
.I \-g
.I group-id
] [
.I \-n
.I nice-value
] [
.I \-u
.I user-id
]
.I /path/to/program
.I argv0
.I ...
.I argvN
.SH DESCRIPTION
The \fBcupsd\-helper\fR programs perform long-running operations on behalf of the scheduler,
.BR cupsd (8).
The \fBcups-deviced\fR helper program runs each CUPS
.BR backend (7)
with no arguments in order to discover the available printers.
.LP
The \fBcups-driverd\fR helper program lists all available printer drivers, a subset of "matching" printer drivers, or a copy of a specific driver PPD file.
.LP
The \fBcups-exec\fR helper program runs backends, filters, and other programs. On macOS these programs are run in a secure sandbox.
.SH FILES
The \fBcups-driverd\fR program looks for PPD and driver information files in the following directories:
.nf

    \fI/Library/Printers\fR
    \fI/opt/share/ppd\fR
    \fI/System/Library/Printers\fR
    \fI/usr/local/share/ppd\fR
    \fI/usr/share/cups/drv\fR
    \fI/usr/share/cups/model\fR
    \fI/usr/share/ppd\fR
.fi
.LP
PPD files can be compressed using the
.BR gzip (1)
program or placed in compressed
.BR tar (1)
archives to further reduce their size.
.LP
Driver information files must conform to the format defined in
.BR ppdcfile (5).
.SH SEE ALSO
.BR backend (7),
.BR cups (1),
.BR cupsd (8),
.BR cupsd.conf (5),
.BR filter (7),
.BR ppdcfile (5),
CUPS Online Help (http://localhost:631/help)
.SH COPYRIGHT
Copyright \[co] 2007-2016 by Apple Inc.
